/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class IssueSecurityLevelResolver {
    private static final Logger log = Logger.getLogger(IssueSecurityLevelResolver.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public IssueSecurityLevelResolver(IssueSecurityLevelManager issueSecurityLevelManager) {
        this.issueSecurityLevelManager = Assertions.notNull("issueSecurityLevelManager", issueSecurityLevelManager);
    }

    public List<GenericValue> getAllSecurityLevels(User searcher) {
        try {
            return new ArrayList<GenericValue>(this.issueSecurityLevelManager.getAllUsersSecurityLevels(searcher));
        }
        catch (GenericEntityException e) {
            log.warn((Object)("Unable to find issue levels for user '" + searcher.getName() + "': " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<GenericValue> getIssueSecurityLevels(User searcher, QueryLiteral rawValue) {
        return this.getIssueSecurityLevels(searcher, Collections.singletonList(rawValue));
    }

    public List<GenericValue> getIssueSecurityLevels(User searcher, List<QueryLiteral> rawValues) {
        return this._getIssueSecurityLevels(searcher, false, rawValues);
    }

    public List<GenericValue> getIssueSecurityLevelsOverrideSecurity(List<QueryLiteral> rawValues) {
        return this._getIssueSecurityLevels(null, true, rawValues);
    }

    private List<GenericValue> _getIssueSecurityLevels(User searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        Assertions.notNull("rawValues", rawValues);
        ArrayList<GenericValue> matchingLevels = new ArrayList<GenericValue>();
        for (QueryLiteral rawValue : rawValues) {
            Assertions.notNull("rawValue", rawValue);
            if (rawValue.getStringValue() != null) {
                matchingLevels.addAll(this.getIssueSecurityLevelsForString(searcher, overrideSecurity, rawValue.getStringValue()));
                continue;
            }
            if (rawValue.getLongValue() != null) {
                matchingLevels.addAll(this.getIssueSecurityLevelsForLong(searcher, overrideSecurity, rawValue.getLongValue()));
                continue;
            }
            if (!rawValue.isEmpty()) continue;
            matchingLevels.add(null);
        }
        return matchingLevels;
    }

    private Collection<GenericValue> getIssueSecurityLevelsForString(User searcher, boolean overrideSecurity, String rawValue) {
        GenericValue securityLevel;
        Long valueAsLong;
        Collection<GenericValue> levels = this.getIssueSecurityLevelsByName(searcher, overrideSecurity, rawValue);
        if (levels == null) {
            levels = new LinkedHashSet<GenericValue>();
        }
        if (levels.isEmpty() && (valueAsLong = this.getValueAsLong(rawValue)) != null && (securityLevel = this.getIssueSecurityLevelById(searcher, overrideSecurity, valueAsLong)) != null) {
            levels.add(securityLevel);
        }
        return levels;
    }

    private List<GenericValue> getIssueSecurityLevelsForLong(User searcher, boolean overrideSecurity, Long rawValue) {
        ArrayList<GenericValue> levels = new ArrayList<GenericValue>();
        GenericValue level = this.getIssueSecurityLevelById(searcher, overrideSecurity, rawValue);
        if (level != null) {
            levels.add(level);
        } else {
            Collection<GenericValue> securityLevelsByName = this.getIssueSecurityLevelsByName(searcher, overrideSecurity, rawValue.toString());
            if (securityLevelsByName != null) {
                levels.addAll(securityLevelsByName);
            }
        }
        return levels;
    }

    GenericValue getIssueSecurityLevelById(User searcher, boolean overrideSecurity, Long valueAsLong) {
        try {
            Collection<GenericValue> usersSecurityLevels = overrideSecurity ? this.issueSecurityLevelManager.getAllSecurityLevels() : this.issueSecurityLevelManager.getAllUsersSecurityLevels(searcher);
            for (GenericValue level : usersSecurityLevels) {
                if (!valueAsLong.equals(level.getLong("id"))) continue;
                return level;
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    Collection<GenericValue> getIssueSecurityLevelsByName(User searcher, boolean overrideSecurity, String nameValue) {
        try {
            return overrideSecurity ? this.issueSecurityLevelManager.getSecurityLevelsByName(nameValue) : this.issueSecurityLevelManager.getUsersSecurityLevelsByName(searcher, nameValue);
        }
        catch (GenericEntityException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private Long getValueAsLong(String singleValueOperand) {
        try {
            return new Long(singleValueOperand);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

