/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.List;

public class ComponentIndexInfoResolver
implements IndexInfoResolver<ProjectComponent> {
    private final NameResolver<ProjectComponent> componentResolver;

    public ComponentIndexInfoResolver(NameResolver<ProjectComponent> componentResolver) {
        this.componentResolver = componentResolver;
    }

    @Override
    public List<String> getIndexedValues(String rawValue) {
        Long componentId;
        Assertions.notNull("rawValue", rawValue);
        List<String> components = this.componentResolver.getIdsFromName(rawValue);
        if (components.isEmpty() && (componentId = this.getValueAsLong(rawValue)) != null && this.componentResolver.idExists(componentId)) {
            components = Collections.singletonList(rawValue);
        }
        return components;
    }

    @Override
    public List<String> getIndexedValues(Long rawValue) {
        Assertions.notNull("rawValue", rawValue);
        if (this.componentResolver.idExists(rawValue)) {
            return CollectionBuilder.newBuilder(rawValue.toString()).asList();
        }
        return this.componentResolver.getIdsFromName(rawValue.toString());
    }

    @Override
    public String getIndexedValue(ProjectComponent component) {
        Assertions.notNull("component", component);
        return this.getIdAsString(component);
    }

    private String getIdAsString(ProjectComponent component) {
        return component.getId().toString();
    }

    private Long getValueAsLong(String value) {
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

