/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.EqualityQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.RelationalOperatorMutatedIndexValueQueryFactory;
import com.atlassian.jira.jql.resolver.WorkRatioIndexInfoResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.List;

@InjectableComponent
public class WorkRatioClauseQueryFactory
implements ClauseQueryFactory {
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final ApplicationProperties applicationProperties;

    public WorkRatioClauseQueryFactory(JqlOperandResolver operandResolver, ApplicationProperties applicationProperties) {
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        WorkRatioIndexInfoResolver workRatioIndexInfoResolver = new WorkRatioIndexInfoResolver();
        operatorFactories.add(new EqualityQueryFactory<Object>(workRatioIndexInfoResolver));
        operatorFactories.add(new RelationalOperatorMutatedIndexValueQueryFactory(workRatioIndexInfoResolver));
        this.delegateClauseQueryFactory = this.createGenericClauseQueryFactory(operandResolver, operatorFactories);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.applicationProperties.getOption("jira.option.timetracking")) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        return QueryFactoryResult.createFalseResult();
    }

    GenericClauseQueryFactory createGenericClauseQueryFactory(JqlOperandResolver operandResolver, List<OperatorSpecificQueryFactory> operatorFactories) {
        return new GenericClauseQueryFactory(SystemSearchConstants.forWorkRatio(), operatorFactories, operandResolver);
    }
}

