/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import org.apache.log4j.Logger;

public class ValidatingDecoratorQueryFactory
implements ClauseQueryFactory {
    private final OperatorUsageValidator validator;
    private final ClauseQueryFactory delegate;

    public ValidatingDecoratorQueryFactory(OperatorUsageValidator validator, ClauseQueryFactory delegate) {
        this.delegate = Assertions.notNull("delegate", delegate);
        this.validator = Assertions.notNull("validator", validator);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.validator.check(queryCreationContext.getQueryUser(), terminalClause)) {
            return this.delegate.getQuery(queryCreationContext, terminalClause);
        }
        Logger log = Logger.getLogger(this.getClass());
        log.warn((Object)("Unable to create query for clause '" + terminalClause + "': Invalid operator and argument combination."));
        return QueryFactoryResult.createFalseResult();
    }
}

