/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.jql.query.ChangedClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.QueryRegistry;
import com.atlassian.jira.jql.query.WasClauseQueryFactory;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

class QueryVisitor
implements ClauseVisitor<QueryFactoryResult> {
    private final QueryRegistry queryRegistry;
    private final QueryCreationContext queryCreationContext;
    private final DeMorgansVisitor deMorgansVisitor;
    private boolean rootClause = true;

    QueryVisitor(QueryRegistry queryRegistry, QueryCreationContext queryCreationContext) {
        this(queryRegistry, queryCreationContext, new DeMorgansVisitor());
    }

    QueryVisitor(QueryRegistry queryRegistry, QueryCreationContext queryCreationContext, DeMorgansVisitor deMorgansVisitor) {
        this.queryRegistry = queryRegistry;
        this.queryCreationContext = queryCreationContext;
        this.deMorgansVisitor = deMorgansVisitor;
    }

    public Query createQuery(Clause clause) {
        this.rootClause = false;
        Clause normalisedClause = clause.accept(this.deMorgansVisitor);
        QueryFactoryResult queryFactoryResult = normalisedClause.accept(this);
        return QueryVisitor.makeQuery(queryFactoryResult);
    }

    @Override
    public QueryFactoryResult visit(AndClause andClause) {
        if (this.rootClause) {
            return new QueryFactoryResult(this.createQuery(andClause));
        }
        if (andClause.getClauses().size() > BooleanQuery.getMaxClauseCount()) {
            throw new JqlTooComplex(andClause);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Clause clause : andClause.getClauses()) {
            QueryFactoryResult queryFactoryResult = clause.accept(this);
            if (queryFactoryResult.mustNotOccur()) {
                booleanQuery.add(queryFactoryResult.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(queryFactoryResult.getLuceneQuery(), BooleanClause.Occur.MUST);
        }
        return new QueryFactoryResult((Query)booleanQuery);
    }

    @Override
    public QueryFactoryResult visit(OrClause orClause) {
        if (this.rootClause) {
            return new QueryFactoryResult(this.createQuery(orClause));
        }
        if (orClause.getClauses().size() > BooleanQuery.getMaxClauseCount()) {
            throw new JqlTooComplex(orClause);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        for (Clause clause : orClause.getClauses()) {
            QueryFactoryResult queryFactoryResult = clause.accept(this);
            booleanQuery.add(QueryVisitor.makeQuery(queryFactoryResult), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)booleanQuery);
    }

    @Override
    public QueryFactoryResult visit(NotClause notClause) {
        if (this.rootClause) {
            return new QueryFactoryResult(this.createQuery(notClause));
        }
        throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.");
    }

    @Override
    public QueryFactoryResult visit(TerminalClause terminalClause) {
        if (this.rootClause) {
            return new QueryFactoryResult(this.createQuery(terminalClause));
        }
        Collection<ClauseQueryFactory> clauseQueryFactory = this.queryRegistry.getClauseQueryFactory(this.queryCreationContext, terminalClause);
        if (clauseQueryFactory.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        try {
            if (clauseQueryFactory.size() == 1) {
                ClauseQueryFactory factory = clauseQueryFactory.iterator().next();
                return factory.getQuery(this.queryCreationContext, terminalClause);
            }
            BooleanQuery query = new BooleanQuery();
            for (ClauseQueryFactory factory : clauseQueryFactory) {
                query.add(QueryVisitor.makeQuery(factory.getQuery(this.queryCreationContext, terminalClause)), BooleanClause.Occur.SHOULD);
            }
            return new QueryFactoryResult((Query)query);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            throw new JqlTooComplex(terminalClause);
        }
        catch (JqlTooComplex jqlTooComplex) {
            throw new JqlTooComplex(terminalClause);
        }
    }

    @Override
    public QueryFactoryResult visit(WasClause clause) {
        WasClauseQueryFactory queryFactory = ComponentManager.getComponent(WasClauseQueryFactory.class);
        return queryFactory.create(this.queryCreationContext.getUser(), clause);
    }

    @Override
    public QueryFactoryResult visit(ChangedClause clause) {
        ChangedClauseQueryFactory queryFactory = ComponentManager.getComponent(ChangedClauseQueryFactory.class);
        return queryFactory.create(this.queryCreationContext.getUser(), clause);
    }

    private static Query makeQuery(QueryFactoryResult queryFactoryResult) {
        if (queryFactoryResult.mustNotOccur()) {
            BooleanQuery query = new BooleanQuery();
            query.add(queryFactoryResult.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
            return query;
        }
        return queryFactoryResult.getLuceneQuery();
    }

    static class JqlTooComplex
    extends RuntimeException {
        private final Clause clause;

        JqlTooComplex(Clause clause) {
            this.clause = clause;
        }

        public Clause getClause() {
            return this.clause;
        }
    }
}

