/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionQueryFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.EqualityQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.UserIndexInfoResolver;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

class PermissionClauseQueryFactory
implements ClauseQueryFactory {
    private final ClauseQueryFactory clauseQueryFactory;
    private final PermissionQueryFactory permissionQueryFactory;
    private final JqlOperandResolver operandResolver;
    private final CurrentUser currentUser;
    private final IndexInfoResolver<User> infoResolver;
    private final int permissionId;

    static PermissionClauseQueryFactory create(JqlOperandResolver operandResolver, UserResolver userResolver, PermissionQueryFactory permissionQueryFactory, String field) {
        UserIndexInfoResolver indexInfoResolver = new UserIndexInfoResolver(userResolver);
        List<OperatorSpecificQueryFactory> operatorQueryFactory = Collections.singletonList(new EqualityQueryFactory<User>(indexInfoResolver));
        GenericClauseQueryFactory clauseQueryFactory = new GenericClauseQueryFactory(field, operatorQueryFactory, operandResolver);
        PermissionClauseQueryFactory permissionClauseQueryFactory = new PermissionClauseQueryFactory(clauseQueryFactory, permissionQueryFactory, operandResolver, 31, new OverrideField(field), indexInfoResolver);
        return permissionClauseQueryFactory;
    }

    PermissionClauseQueryFactory(ClauseQueryFactory clauseQueryFactory, PermissionQueryFactory permissionQueryFactory, JqlOperandResolver operandResolver, int permissionId, CurrentUser currentUser, IndexInfoResolver<User> infoResolver) {
        this.clauseQueryFactory = Assertions.notNull("clauseQueryFactory", clauseQueryFactory);
        this.permissionQueryFactory = Assertions.notNull("permissionQueryFactory", permissionQueryFactory);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.currentUser = Assertions.notNull("currentUser", currentUser);
        this.infoResolver = Assertions.notNull("infoResolver", infoResolver);
        this.permissionId = permissionId;
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        QueryFactoryResult delegateResult = this.clauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        if (queryCreationContext.isSecurityOverriden()) {
            return delegateResult;
        }
        Query permissionQuery = this.getPermissionQuery(queryCreationContext, terminalClause);
        if (permissionQuery == null) {
            return delegateResult;
        }
        BooleanQuery query = new BooleanQuery();
        query.add(delegateResult.getLuceneQuery(), BooleanClause.Occur.MUST);
        query.add(permissionQuery, BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)query, delegateResult.mustNotOccur());
    }

    Query getPermissionQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        User user = queryCreationContext.getQueryUser();
        List<QueryLiteral> values = this.operandResolver.getValues(queryCreationContext, terminalClause.getOperand(), terminalClause);
        CurrentUser.Presence userPresence = CurrentUser.Presence.get(user, values, this.infoResolver);
        return this.currentUser.rewrite(this.permissionQueryFactory.getQuery(user, this.permissionId), userPresence, user, this.infoResolver);
    }

    static class UserEquals
    implements Predicate<QueryLiteral> {
        private final User user;
        private final IndexInfoResolver<User> infoResolver;

        UserEquals(User user, IndexInfoResolver<User> infoResolver) {
            this.user = user;
            this.infoResolver = infoResolver;
        }

        @Override
        public boolean evaluate(QueryLiteral literal) {
            if (literal.isEmpty()) {
                return false;
            }
            for (String userName : this.infoResolver.getIndexedValues(literal.asString())) {
                if (!UserNames.equal(userName, this.user)) continue;
                return true;
            }
            return false;
        }
    }

    static class OverrideField
    implements CurrentUser {
        private final String field;

        public OverrideField(String field) {
            this.field = field;
        }

        @Override
        public Query rewrite(Query query, CurrentUser.Presence hasUser, User user, IndexInfoResolver<User> resolver) {
            switch (hasUser) {
                case NOT: {
                    return query;
                }
                case ONLY: {
                    return null;
                }
                case CONTAINS: {
                    BooleanQuery result = new BooleanQuery();
                    result.add((Query)new TermQuery(new Term(this.field, resolver.getIndexedValue(user))), BooleanClause.Occur.SHOULD);
                    result.add(query, BooleanClause.Occur.SHOULD);
                    return result;
                }
            }
            throw new IllegalArgumentException("Unknown Presence: " + (Object)((Object)hasUser));
        }
    }

    static interface CurrentUser {
        public Query rewrite(Query var1, Presence var2, User var3, IndexInfoResolver<User> var4);

        public static enum Presence {
            NOT,
            CONTAINS,
            ONLY;


            static Presence get(User user, Collection<QueryLiteral> values, IndexInfoResolver<User> resolver) {
                boolean hasUser;
                boolean bl = hasUser = user != null && CollectionUtil.contains(values, new UserEquals(user, resolver));
                return !hasUser ? NOT : (values.size() == 1 ? ONLY : CONTAINS);
            }
        }
    }
}

