/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IssueSecurityLevelResolver;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericValue;

@InjectableComponent
public class IssueSecurityLevelClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(IssueSecurityLevelClauseQueryFactory.class);
    private static final String indexFieldName = SystemSearchConstants.forSecurityLevel().getIndexField();
    private final IssueSecurityLevelResolver issueSecurityLevelResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public IssueSecurityLevelClauseQueryFactory(IssueSecurityLevelResolver issueSecurityLevelResolver, JqlOperandResolver jqlOperandResolver) {
        this.issueSecurityLevelResolver = Assertions.notNull("issueSecurityLevelResolver", issueSecurityLevelResolver);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        Operator operator = terminalClause.getOperator();
        List<String> securityLevelIds = this.transformRawValuesIntoIds(queryCreationContext, terminalClause);
        return this.createQueryForValues(operator, securityLevelIds);
    }

    QueryFactoryResult createQueryForValues(Operator operator, List<String> securityLevelIds) {
        if (this.isPositiveOperator(operator)) {
            return this.handleIn(securityLevelIds);
        }
        if (this.isNegationOperator(operator)) {
            return this.handleNotIn(securityLevelIds);
        }
        log.warn((Object)String.format("Issue Security Level operands do not support operator '%s'.", operator.getDisplayString()));
        return QueryFactoryResult.createFalseResult();
    }

    private List<String> transformRawValuesIntoIds(QueryCreationContext queryCreationContext, TerminalClause clause) {
        List<QueryLiteral> rawValues = this.jqlOperandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
        ArrayList<String> idStrings = new ArrayList<String>();
        if (rawValues != null) {
            List<GenericValue> securityLevelGVs = queryCreationContext.isSecurityOverriden() ? this.issueSecurityLevelResolver.getIssueSecurityLevelsOverrideSecurity(rawValues) : this.issueSecurityLevelResolver.getIssueSecurityLevels(queryCreationContext.getQueryUser(), rawValues);
            for (GenericValue securityLevelGV : securityLevelGVs) {
                if (securityLevelGV != null) {
                    idStrings.add(securityLevelGV.getLong("id").toString());
                    continue;
                }
                idStrings.add(null);
            }
        }
        return idStrings;
    }

    private QueryFactoryResult handleIn(List<String> values) {
        if (values.size() == 1) {
            String value = values.get(0);
            return new QueryFactoryResult((Query)this.getPossibleTermQuery(value));
        }
        BooleanQuery combined = new BooleanQuery();
        for (String value : values) {
            combined.add((Query)this.getPossibleTermQuery(value), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined);
    }

    private QueryFactoryResult handleNotIn(List<String> values) {
        ArrayList<TermQuery> notQueries = new ArrayList<TermQuery>();
        boolean emptyLiteralFound = false;
        for (String value : values) {
            if (value != null) {
                notQueries.add(this.getTermQuery(value));
                continue;
            }
            emptyLiteralFound = true;
        }
        if (notQueries.isEmpty()) {
            return emptyLiteralFound ? new QueryFactoryResult((Query)this.getEmptyTermQuery(), true) : QueryFactoryResult.createFalseResult();
        }
        BooleanQuery boolQuery = new BooleanQuery();
        QueryFactoryResult notEmptyQuery = new QueryFactoryResult((Query)this.getEmptyTermQuery(), true);
        boolQuery.add(notEmptyQuery.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        return new QueryFactoryResult((Query)boolQuery, false);
    }

    private TermQuery getPossibleTermQuery(String value) {
        return value == null ? this.getEmptyTermQuery() : this.getTermQuery(value);
    }

    private TermQuery getTermQuery(String value) {
        return new TermQuery(new Term(indexFieldName, value));
    }

    private TermQuery getEmptyTermQuery() {
        return this.getTermQuery("-1");
    }

    private boolean isPositiveOperator(Operator operator) {
        return operator == Operator.IS || operator == Operator.EQUALS || operator == Operator.IN;
    }

    private boolean isNegationOperator(Operator operator) {
        return operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN;
    }
}

