/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.JqlIssueSupport;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

@InjectableComponent
public class IssueParentClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(IssueParentClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final JqlIssueSupport issueSupport;
    private final SubTaskManager subTaskManager;

    public IssueParentClauseQueryFactory(JqlOperandResolver operandResolver, JqlIssueSupport issueSupport, SubTaskManager subTaskManager) {
        this.issueSupport = Assertions.notNull("issueSupport", issueSupport);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
        this.subTaskManager = Assertions.notNull("subTaskManager", subTaskManager);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        if (!this.subTaskManager.isSubTasksEnabled()) {
            return QueryFactoryResult.createFalseResult();
        }
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        List<QueryLiteral> literals = this.operandResolver.getValues(queryCreationContext, operand, terminalClause);
        if (literals == null) {
            log.warn((Object)String.format("Unable to find operand values from operand '%s' for clause '%s'.", operand.getDisplayString(), terminalClause.getName()));
            return QueryFactoryResult.createFalseResult();
        }
        if (operator == Operator.EQUALS || operator == Operator.IN) {
            return this.handleEquals(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden(), literals);
        }
        if (operator == Operator.NOT_EQUALS || operator == Operator.NOT_IN) {
            return this.handleNotEquals(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden(), literals);
        }
        log.warn((Object)String.format("The '%s' clause does not support the %s operator.", new Object[]{terminalClause.getName(), operator}));
        return QueryFactoryResult.createFalseResult();
    }

    List<String> getIndexValues(User searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        LinkedList<String> indexValues = new LinkedList<String>();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.getStringValue() != null) {
                List<Issue> issues = overrideSecurity ? this.issueSupport.getIssues(rawValue.getStringValue()) : this.issueSupport.getIssues(rawValue.getStringValue(), searcher);
                indexValues.addAll(CollectionUtil.transform(issues, new Function<Issue, String>(){

                    @Override
                    public String get(Issue input) {
                        return input.getId().toString();
                    }
                }));
                continue;
            }
            if (rawValue.getLongValue() != null) {
                indexValues.add(rawValue.asString());
                continue;
            }
            indexValues.add(null);
        }
        return indexValues;
    }

    private QueryFactoryResult handleNotEquals(User searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(searcher, overrideSecurity, rawValues), true);
    }

    private QueryFactoryResult handleEquals(User searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        return new QueryFactoryResult(this.createPositiveEqualsQuery(searcher, overrideSecurity, rawValues));
    }

    private Query createPositiveEqualsQuery(User searcher, boolean overrideSecurity, List<QueryLiteral> rawValues) {
        List<String> indexValues = this.getIndexValues(searcher, overrideSecurity, rawValues);
        if (indexValues.size() == 1) {
            String value = indexValues.get(0);
            return value == null ? new BooleanQuery() : this.createQuery(value);
        }
        BooleanQuery query = new BooleanQuery();
        for (String indexValue : indexValues) {
            if (indexValue == null) continue;
            query.add(this.createQuery(indexValue), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    private Query createQuery(String indexValue) {
        return new TermQuery(new Term(SystemSearchConstants.forIssueParent().getIndexField(), indexValue));
    }
}

