/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.filters.IssueIdFilter;
import com.atlassian.jira.issue.search.parameters.lucene.CachedWrappedFilterCache;
import com.atlassian.jira.issue.search.parameters.lucene.PermissionsFilterGenerator;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.LikeQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;

public class CommentClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(CommentClauseQueryFactory.class);
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;
    private final SearchProviderFactory searchProviderFactory;
    private final LuceneQueryModifier luceneQueryModifier;
    private final PermissionsFilterGenerator permissionsFilterGenerator;
    private final ClauseQueryFactory delegateClauseQueryFactory;

    public CommentClauseQueryFactory(PermissionManager permissionManager, ProjectRoleManager projectRoleManager, JqlOperandResolver operandResolver, SearchProviderFactory searchProviderFactory, LuceneQueryModifier luceneQueryModifier, PermissionsFilterGenerator permissionsFilterGenerator) {
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
        this.searchProviderFactory = searchProviderFactory;
        this.luceneQueryModifier = luceneQueryModifier;
        this.permissionsFilterGenerator = permissionsFilterGenerator;
        this.delegateClauseQueryFactory = this.getDelegate(operandResolver);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Assertions.notNull("queryCreationContext", queryCreationContext);
        if (!this.isClauseValid(terminalClause)) {
            return QueryFactoryResult.createFalseResult();
        }
        boolean overrideSecurity = queryCreationContext.isSecurityOverriden();
        List<Long> projectIds = null;
        if (!overrideSecurity && (projectIds = this.getVisibleProjectIds(queryCreationContext.getQueryUser())).isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        BooleanQuery levelQuery = null;
        BooleanQuery projectVisibilityQuery = null;
        if (!overrideSecurity) {
            levelQuery = this.createLevelRestrictionQueryForComments(projectIds, queryCreationContext.getQueryUser());
            projectVisibilityQuery = this.createProjectVisibilityQuery(projectIds);
        }
        Query commentBodyQuery = this.luceneQueryModifier.getModifiedQuery(this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause).getLuceneQuery());
        BooleanQuery commentIndexQuery = new BooleanQuery();
        if (levelQuery != null) {
            commentIndexQuery.add((Query)levelQuery, BooleanClause.Occur.MUST);
        }
        commentIndexQuery.add(commentBodyQuery, BooleanClause.Occur.MUST);
        if (projectVisibilityQuery != null) {
            commentIndexQuery.add((Query)projectVisibilityQuery, BooleanClause.Occur.MUST);
        }
        return this.generateIssueIdQueryFromCommentQuery((Query)commentIndexQuery, queryCreationContext);
    }

    boolean isClauseValid(TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!Operator.LIKE.equals((Object)operator) && !Operator.NOT_LIKE.equals((Object)operator)) {
            log.warn((Object)("Can not generate a comment clause query for a clause with operator '" + operator.getDisplayString() + "'."));
            return false;
        }
        return true;
    }

    QueryFactoryResult generateIssueIdQueryFromCommentQuery(Query commentIndexQuery, QueryCreationContext creationContext) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Searching the comment index using the query: " + commentIndexQuery.toString()));
            }
            IndexSearcher commentSearcher = this.searchProviderFactory.getSearcher("comments");
            Filter filter = this.getPermissionsFilter(creationContext.isSecurityOverriden(), creationContext.getQueryUser());
            final HashSet<String> issueIds = new HashSet<String>();
            DocumentHitCollector hitCollector = new DocumentHitCollector(commentSearcher){

                @Override
                public void collect(Document doc) {
                    issueIds.add(doc.get("issue_id"));
                }
            };
            if (filter == null) {
                commentSearcher.search(commentIndexQuery, (Collector)hitCollector);
            } else {
                commentSearcher.search(commentIndexQuery, filter, (Collector)hitCollector);
            }
            return new QueryFactoryResult((Query)new ConstantScoreQuery((Filter)new IssueIdFilter(issueIds)));
        }
        catch (IOException e) {
            log.error((Object)"Unable to search the comment index - returning false result.", (Throwable)e);
            return QueryFactoryResult.createFalseResult();
        }
    }

    TermQuery getTermQuery(String documentConstant, String value) {
        return new TermQuery(new Term(documentConstant, value));
    }

    ClauseQueryFactory getDelegate(JqlOperandResolver jqlOperandResolver) {
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        operatorFactories.add(new LikeQueryFactory(false));
        return new GenericClauseQueryFactory("body", operatorFactories, jqlOperandResolver);
    }

    BooleanQuery createProjectVisibilityQuery(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return null;
        }
        BooleanQuery visibilityQuery = new BooleanQuery();
        for (Long projectId : projectIds) {
            visibilityQuery.add((Query)this.getTermQuery(SystemSearchConstants.forProject().getIndexField(), projectId.toString()), BooleanClause.Occur.SHOULD);
        }
        return visibilityQuery;
    }

    BooleanQuery createLevelRestrictionQueryForComments(List<Long> projectIds, User searcher) {
        BooleanQuery levelQuery = new BooleanQuery();
        Query noGroupOrLevelConstraints = this.createNoGroupOrProjectRoleLevelQuery();
        levelQuery.add(noGroupOrLevelConstraints, BooleanClause.Occur.SHOULD);
        if (searcher != null) {
            ProjectRoleManager.ProjectIdToProjectRoleIdsMap projectIdToProjectRolesMap;
            Set<String> groups = this.getGroups(searcher);
            if (!groups.isEmpty()) {
                levelQuery.add(this.createGroupLevelQuery(groups), BooleanClause.Occur.SHOULD);
            }
            if (!(projectIdToProjectRolesMap = this.projectRoleManager.createProjectIdToProjectRolesMap(searcher, projectIds)).isEmpty()) {
                Query query = this.createProjectRoleLevelQuery(projectIdToProjectRolesMap);
                levelQuery.add(query, BooleanClause.Occur.SHOULD);
            }
        }
        return levelQuery;
    }

    Set<String> getGroups(User searcher) {
        UserUtil userUtil = ComponentManager.getComponent(UserUtil.class);
        return userUtil.getGroupNamesForUser(searcher.getName());
    }

    Query createGroupLevelQuery(Set<String> groups) {
        BooleanQuery query = new BooleanQuery();
        if (groups == null || groups.isEmpty()) {
            log.warn((Object)"Groups must be specified!");
            return query;
        }
        for (String group : groups) {
            query.add((Query)this.getTermQuery("level", group), BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    Query createNoGroupOrProjectRoleLevelQuery() {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)this.getTermQuery("level", "-1"), BooleanClause.Occur.MUST);
        query.add((Query)this.getTermQuery("role_level", "-1"), BooleanClause.Occur.MUST);
        return query;
    }

    Query createProjectRoleLevelQuery(ProjectRoleManager.ProjectIdToProjectRoleIdsMap projectIdToProjectRolesMap) {
        BooleanQuery query = new BooleanQuery();
        if (projectIdToProjectRolesMap == null || projectIdToProjectRolesMap.isEmpty()) {
            log.warn((Object)"Groups must be specified!");
            return query;
        }
        for (ProjectRoleManager.ProjectIdToProjectRoleIdsMap.Entry entry : projectIdToProjectRolesMap) {
            Long projectId = entry.getProjectId();
            List<Long> projectRoles = entry.getProjectRoleIds();
            for (Object e : projectRoles) {
                Long projectRoleId = (Long)e;
                query.add(this.createCommentInProjectAndUserInRoleQuery(projectId, projectRoleId), BooleanClause.Occur.SHOULD);
            }
        }
        return query;
    }

    Query createCommentInProjectAndUserInRoleQuery(Long projectId, Long projectRoleId) {
        BooleanQuery query = new BooleanQuery();
        if (projectId == null) {
            log.warn((Object)"projectId must be specified!");
            return query;
        }
        if (projectRoleId == null) {
            log.warn((Object)"projectRoleId must be specified!");
            return query;
        }
        query.add((Query)this.getTermQuery(SystemSearchConstants.forProject().getIndexField(), projectId.toString()), BooleanClause.Occur.MUST);
        query.add((Query)this.getTermQuery("role_level", projectRoleId.toString()), BooleanClause.Occur.MUST);
        return query;
    }

    List<Long> getVisibleProjectIds(User searcher) {
        Collection<Project> projects = this.permissionManager.getProjectObjects(10, searcher);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (projects != null) {
            for (Project project : projects) {
                if (project == null) continue;
                projectIds.add(project.getId());
            }
        }
        return projectIds;
    }

    Filter getPermissionsFilter(boolean overRideSecurity, User searchUser) {
        if (!overRideSecurity) {
            CachedWrappedFilterCache cache = this.getCachedWrappedFilterCache();
            Filter filter = cache.getFilter(searchUser);
            if (filter != null) {
                return filter;
            }
            Query permissionQuery = this.permissionsFilterGenerator.getQuery(searchUser);
            filter = new CachingWrapperFilter((Filter)new QueryWrapperFilter(permissionQuery));
            cache.storeFilter(filter, searchUser);
            return filter;
        }
        return null;
    }

    CachedWrappedFilterCache getCachedWrappedFilterCache() {
        CachedWrappedFilterCache cache = (CachedWrappedFilterCache)JiraAuthenticationContextImpl.getRequestCache().get("jira.cached.wrapped.filter.cache");
        if (cache == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new CachedWrappedFilterCache");
            }
            cache = new CachedWrappedFilterCache();
            JiraAuthenticationContextImpl.getRequestCache().put("jira.cached.wrapped.filter.cache", cache);
        }
        return cache;
    }
}

