/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ActualValueEqualityQueryFactory;
import com.atlassian.jira.jql.query.ActualValueRelationalQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.GenericClauseQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.JqlDurationSupport;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import java.util.ArrayList;
import java.util.List;

public class AbstractTimeTrackingClauseQueryFactory
implements ClauseQueryFactory {
    private final ClauseQueryFactory delegateClauseQueryFactory;
    private final ApplicationProperties applicationProperties;

    public AbstractTimeTrackingClauseQueryFactory(String indexField, JqlOperandResolver operandResolver, JqlDurationSupport jqlDurationSupport, ApplicationProperties applicationProperties) {
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        ArrayList<OperatorSpecificQueryFactory> operatorFactories = new ArrayList<OperatorSpecificQueryFactory>();
        operatorFactories.add(new ActualValueEqualityQueryFactory(jqlDurationSupport, "-1"));
        operatorFactories.add(new ActualValueRelationalQueryFactory(jqlDurationSupport, "-1"));
        this.delegateClauseQueryFactory = this.createGenericClauseQueryFactory(indexField, operandResolver, operatorFactories);
    }

    @Override
    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        if (this.applicationProperties.getOption("jira.option.timetracking")) {
            return this.delegateClauseQueryFactory.getQuery(queryCreationContext, terminalClause);
        }
        return QueryFactoryResult.createFalseResult();
    }

    GenericClauseQueryFactory createGenericClauseQueryFactory(String indexField, JqlOperandResolver operandResolver, List<OperatorSpecificQueryFactory> operatorFactories) {
        return new GenericClauseQueryFactory(indexField, operatorFactories, operandResolver);
    }
}

