/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractDateOperatorQueryFactory {
    private final JqlDateSupport jqlDateSupport;

    protected AbstractDateOperatorQueryFactory(JqlDateSupport jqlDateSupport) {
        this.jqlDateSupport = Assertions.notNull("jqlDateSupport", jqlDateSupport);
    }

    List<Date> getDateValues(List<QueryLiteral> rawValues) {
        ArrayList<Date> dates = new ArrayList<Date>();
        for (QueryLiteral rawValue : rawValues) {
            Date date;
            if (rawValue.getLongValue() != null) {
                date = this.jqlDateSupport.convertToDate(rawValue.getLongValue());
                if (date == null) continue;
                dates.add(date);
                continue;
            }
            if (rawValue.getStringValue() != null) {
                date = this.jqlDateSupport.convertToDate(rawValue.getStringValue());
                if (date == null) continue;
                dates.add(date);
                continue;
            }
            dates.add(null);
        }
        return dates;
    }
}

