/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.permission.AbstractLiteralSanitisingVisitor;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.LiteralSanitiser;
import com.atlassian.jira.jql.permission.ProjectLiteralSanitiser;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.Operand;

public class ProjectClauseValueSanitiser
implements ClauseSanitiser {
    private final PermissionManager permissionManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final NameResolver<Project> projectResolver;

    public ProjectClauseValueSanitiser(PermissionManager permissionManager, JqlOperandResolver jqlOperandResolver, NameResolver<Project> projectResolver) {
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.projectResolver = Assertions.notNull("projectResolver", projectResolver);
    }

    @Override
    public Clause sanitise(User user, TerminalClause clause) {
        Operand sanitisedOperand;
        ProjectOperandSanitisingVisitor visitor = this.createOperandVisitor(user, clause);
        Operand originalOperand = clause.getOperand();
        if (originalOperand.equals(sanitisedOperand = originalOperand.accept(visitor))) {
            return clause;
        }
        return new TerminalClauseImpl(clause.getName(), clause.getOperator(), sanitisedOperand);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectClauseValueSanitiser sanitiser = (ProjectClauseValueSanitiser)o;
        if (!this.jqlOperandResolver.equals(sanitiser.jqlOperandResolver)) {
            return false;
        }
        if (!this.permissionManager.equals(sanitiser.permissionManager)) {
            return false;
        }
        return this.projectResolver.equals(sanitiser.projectResolver);
    }

    public int hashCode() {
        int result = this.permissionManager.hashCode();
        result = 31 * result + this.jqlOperandResolver.hashCode();
        result = 31 * result + this.projectResolver.hashCode();
        return result;
    }

    ProjectOperandSanitisingVisitor createOperandVisitor(User user, TerminalClause terminalClause) {
        return new ProjectOperandSanitisingVisitor(this.jqlOperandResolver, this.projectResolver, this.permissionManager, user, terminalClause);
    }

    static class ProjectOperandSanitisingVisitor
    extends AbstractLiteralSanitisingVisitor {
        private final NameResolver<Project> projectResolver;
        private final PermissionManager permissionManager;
        private final User user;

        ProjectOperandSanitisingVisitor(JqlOperandResolver jqlOperandResolver, NameResolver<Project> projectResolver, PermissionManager permissionManager, User user, TerminalClause terminalClause) {
            super(jqlOperandResolver, user, terminalClause);
            this.projectResolver = projectResolver;
            this.permissionManager = permissionManager;
            this.user = user;
        }

        @Override
        protected LiteralSanitiser createLiteralSanitiser() {
            return new ProjectLiteralSanitiser(this.projectResolver, this.permissionManager, this.user);
        }
    }
}

