/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;

@NonInjectableComponent
public class FieldClausePermissionChecker
implements ClausePermissionChecker {
    private final FieldManager fieldManager;
    private final Field field;

    public FieldClausePermissionChecker(Field field, FieldManager fieldManager) {
        this.fieldManager = Assertions.notNull("fieldManager", fieldManager);
        this.field = Assertions.notNull("field", field);
    }

    @Override
    public boolean hasPermissionToUseClause(User user) {
        return !this.fieldManager.isFieldHidden(user, this.field);
    }

    public static final class DefaultFactory
    implements Factory {
        @Override
        public ClausePermissionChecker createPermissionChecker(Field field) {
            return new FieldClausePermissionChecker(field, DefaultFactory.getFieldManager());
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(String fieldId) {
            Field field = DefaultFactory.getFieldManager().getField(fieldId);
            return new FieldClausePermissionChecker(field, DefaultFactory.getFieldManager());
        }

        private static FieldManager getFieldManager() {
            return ComponentManager.getInstance().getFieldManager();
        }
    }

    @InjectableComponent
    public static interface Factory {
        public ClausePermissionChecker createPermissionChecker(Field var1);

        public ClausePermissionChecker createPermissionChecker(String var1);
    }
}

