/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.LinkedHashSet;

public class DefaultOperandSanitisingVisitor
implements OperandVisitor<Operand> {
    private final JqlOperandResolver jqlOperandResolver;
    private final User searcher;

    public DefaultOperandSanitisingVisitor(JqlOperandResolver jqlOperandResolver, User searcher) {
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.searcher = searcher;
    }

    @Override
    public Operand visit(EmptyOperand empty) {
        return empty;
    }

    @Override
    public Operand visit(FunctionOperand function) {
        return this.jqlOperandResolver.sanitiseFunctionOperand(this.searcher, function);
    }

    @Override
    public Operand visit(MultiValueOperand originalMulti) {
        boolean isModified = false;
        LinkedHashSet<Operand> sanitisedOperands = new LinkedHashSet<Operand>();
        for (Operand childOperand : originalMulti.getValues()) {
            Operand sanitisedChild = childOperand.accept(this);
            if (!sanitisedChild.equals(childOperand)) {
                isModified = true;
            }
            sanitisedOperands.add(sanitisedChild);
        }
        return isModified ? new MultiValueOperand(sanitisedOperands) : originalMulti;
    }

    @Override
    public Operand visit(SingleValueOperand singleValueOperand) {
        return singleValueOperand;
    }
}

