/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.permission;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

@NonInjectableComponent
public class CustomFieldClausePermissionChecker
implements ClausePermissionChecker {
    private final FieldManager fieldManager;
    private final CustomField field;
    private final FieldConfigSchemeClauseContextUtil clauseContextUtil;

    public CustomFieldClausePermissionChecker(CustomField field, FieldManager fieldManager, FieldConfigSchemeClauseContextUtil clauseContextUtil) {
        this.clauseContextUtil = Assertions.notNull("clauseContextUtil", clauseContextUtil);
        this.fieldManager = Assertions.notNull("fieldManager", fieldManager);
        this.field = Assertions.notNull("field", field);
    }

    @Override
    public boolean hasPermissionToUseClause(User user) {
        if (!this.fieldManager.isFieldHidden(user, this.field)) {
            List<FieldConfigScheme> fieldConfigSchemes = this.field.getConfigurationSchemes();
            for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
                ClauseContext context = this.clauseContextUtil.getContextForConfigScheme(user, fieldConfigScheme);
                if (context.getContexts().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static final class DefaultFactory
    implements Factory {
        @Override
        public ClausePermissionChecker createPermissionChecker(CustomField field, FieldConfigSchemeClauseContextUtil contextUtil) {
            return new CustomFieldClausePermissionChecker(field, DefaultFactory.getFieldManager(), contextUtil);
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(String fieldId, FieldConfigSchemeClauseContextUtil contextUtil) {
            CustomField field = DefaultFactory.getFieldManager().getCustomField(fieldId);
            return new CustomFieldClausePermissionChecker(field, DefaultFactory.getFieldManager(), contextUtil);
        }

        private static FieldManager getFieldManager() {
            return ComponentManager.getInstance().getFieldManager();
        }
    }

    @InjectableComponent
    public static interface Factory {
        public ClausePermissionChecker createPermissionChecker(CustomField var1, FieldConfigSchemeClauseContextUtil var2);

        public ClausePermissionChecker createPermissionChecker(String var1, FieldConfigSchemeClauseContextUtil var2);
    }
}

