/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.parser.antlr;

import com.atlassian.jira.jql.parser.JqlParseErrorMessage;
import com.atlassian.jira.jql.parser.JqlParseErrorMessages;
import com.atlassian.jira.jql.parser.antlr.AntlrPosition;
import com.atlassian.jira.jql.parser.antlr.RuntimeRecognitionException;
import com.atlassian.jira.util.dbc.Assertions;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;

class LexerErrorHelper {
    private final CharStream stream;
    private final AntlrPosition position;

    LexerErrorHelper(CharStream stream, AntlrPosition position) {
        this.stream = Assertions.notNull("stream", stream);
        this.position = position;
    }

    void handleError(RecognitionException re) {
        JqlParseErrorMessage message;
        if (this.position == null) {
            message = JqlParseErrorMessages.genericParseError(this.stream.getLine(), this.stream.getCharPositionInLine());
        } else {
            switch (this.position.getTokenType()) {
                case 48: {
                    message = this.handleEscape();
                    break;
                }
                case 35: 
                case 36: {
                    message = this.handleStringError();
                    break;
                }
                case 58: {
                    message = this.handleErrorCharacter();
                    break;
                }
                case 57: {
                    message = this.handleReservedCharacter();
                    break;
                }
                default: {
                    message = JqlParseErrorMessages.genericParseError(this.position.getLineNumber(), this.position.getCharNumber());
                }
            }
        }
        throw new RuntimeRecognitionException(message, (Throwable)re);
    }

    private JqlParseErrorMessage handleErrorCharacter() {
        JqlParseErrorMessage message;
        char currentChar = (char)this.stream.LT(1);
        if (LexerErrorHelper.isQuote(currentChar)) {
            boolean nextEof;
            boolean bl = nextEof = this.stream.LT(2) == -1;
            if (nextEof) {
                message = JqlParseErrorMessages.unfinishedString(null, this.position.getLineNumber(), this.position.getCharNumber());
            } else {
                int marker = this.stream.mark();
                this.stream.consume();
                char nextChar = (char)this.stream.LT(1);
                message = LexerErrorHelper.isNewLine(nextChar) ? JqlParseErrorMessages.unfinishedString(null, this.position.getLineNumber(), this.position.getCharNumber()) : JqlParseErrorMessages.illegalCharacter(nextChar, this.stream.getLine(), this.stream.getCharPositionInLine());
                this.stream.rewind(marker);
            }
        } else if (LexerErrorHelper.isEscape(currentChar)) {
            boolean nextEof = this.stream.LT(2) == -1;
            String text = nextEof ? null : this.stream.substring(this.position.getIndex(), this.getIndex() + 1);
            message = JqlParseErrorMessages.illegalEsacpe(text, this.position.getLineNumber(), this.position.getCharNumber());
        } else {
            message = JqlParseErrorMessages.illegalCharacter(currentChar, this.position.getLineNumber(), this.position.getCharNumber());
        }
        return message;
    }

    private JqlParseErrorMessage handleReservedCharacter() {
        char currentChar = (char)this.stream.LT(1);
        return JqlParseErrorMessages.reservedCharacter(currentChar, this.position.getLineNumber(), this.position.getCharNumber());
    }

    private JqlParseErrorMessage handleStringError() {
        JqlParseErrorMessage message;
        int currentInt = this.stream.LT(1);
        if (currentInt == -1) {
            String text = this.stream.substring(this.position.getIndex() + 1, this.getIndex() - 1);
            message = JqlParseErrorMessages.unfinishedString(text, this.position.getLineNumber(), this.position.getCharNumber());
        } else {
            char currentChar = (char)currentInt;
            if (LexerErrorHelper.isNewLine(currentChar)) {
                String text = this.stream.substring(this.position.getIndex() + 1, this.getIndex() - 1);
                message = JqlParseErrorMessages.unfinishedString(text, this.position.getLineNumber(), this.position.getCharNumber());
            } else {
                message = JqlParseErrorMessages.illegalCharacter(currentChar, this.stream.getLine(), this.stream.getCharPositionInLine());
            }
        }
        return message;
    }

    private JqlParseErrorMessage handleEscape() {
        int index = this.stream.LT(1) == -1 ? this.getIndex() - 1 : this.getIndex();
        String text = index <= this.position.getIndex() ? null : this.stream.substring(this.position.getIndex(), index);
        return JqlParseErrorMessages.illegalEsacpe(text, this.position.getLineNumber(), this.position.getCharNumber());
    }

    private static boolean isNewLine(char ch) {
        return ch == '\r' || ch == '\n';
    }

    private static boolean isQuote(char ch) {
        return ch == '\'' || ch == '\"';
    }

    private static boolean isEscape(char ch) {
        return ch == '\\';
    }

    private int getIndex() {
        return this.stream.index();
    }
}

