/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand.registry;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.registry.PredicateRegistry;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.UserClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.query.operator.Operator;
import java.util.Collection;

public class DefaultPredicateRegistry
implements PredicateRegistry {
    private final UserPickerSearchService userPickerSearchService;
    private final SearchHandlerManager searchHandlerManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultPredicateRegistry(UserPickerSearchService userPickerSearchService, SearchHandlerManager searchHandlerManager, JiraAuthenticationContext authenticationContext) {
        this.userPickerSearchService = userPickerSearchService;
        this.searchHandlerManager = searchHandlerManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public ClauseValuesGenerator getClauseValuesGenerator(String predicateName, String fieldName) {
        if (Operator.BY.name().equalsIgnoreCase(predicateName)) {
            return new UserClauseValuesGenerator(this.userPickerSearchService);
        }
        if (Operator.FROM.name().equalsIgnoreCase(predicateName) || Operator.TO.name().equalsIgnoreCase(predicateName)) {
            return this.getClauseValuesGeneratorForField(fieldName);
        }
        return null;
    }

    private ClauseValuesGenerator getClauseValuesGeneratorForField(String fieldName) {
        ClauseHandler clauseHandler;
        User searcher = this.authenticationContext.getLoggedInUser();
        Collection<ClauseHandler> clauseHandlers = this.searchHandlerManager.getClauseHandler(searcher, fieldName);
        if (clauseHandlers != null && clauseHandlers.size() == 1 && (clauseHandler = clauseHandlers.iterator().next()) instanceof ValueGeneratingClauseHandler) {
            return ((ValueGeneratingClauseHandler)((Object)clauseHandler)).getClauseValuesGenerator();
        }
        return null;
    }
}

