/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.StatusResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatusClauseContextFactory
implements ClauseContextFactory {
    private static final Logger log = Logger.getLogger(StatusClauseContextFactory.class);
    private final JqlOperandResolver jqlOperandResolver;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueConstantInfoResolver<?> issueConstantInfoResolver;

    public StatusClauseContextFactory(JqlOperandResolver jqlOperandResolver, StatusResolver statusResolver, WorkflowManager workflowManager, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, WorkflowSchemeManager workflowSchemeManager) {
        this.workflowManager = workflowManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.issueConstantInfoResolver = new IssueConstantInfoResolver<Status>(statusResolver);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        boolean isEquality = this.isEqualityOperator(operator);
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set<ProjectIssueTypeContext> projectIssueTypeContexts = this.getContextFromStatusValues(searcher, terminalClause, isEquality);
        return projectIssueTypeContexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(projectIssueTypeContexts);
    }

    Set<ProjectIssueTypeContext> getContextFromStatusValues(User searcher, TerminalClause clause, boolean equality) {
        Set<String> ids = this.getIds(searcher, clause);
        if (ids.isEmpty()) {
            return Collections.emptySet();
        }
        boolean allProjects = true;
        boolean allIssueTypesAcrossAllProjects = true;
        HashMap<String, Boolean> resultCache = new HashMap<String, Boolean>();
        HashSet<ProjectIssueTypeContext> allContexts = new HashSet<ProjectIssueTypeContext>();
        Collection<Project> projects = this.permissionManager.getProjectObjects(10, searcher);
        for (Project project : projects) {
            boolean projectAdded = false;
            boolean allIssueTypesAcrossProject = true;
            Set<Object> projectIssueTypeContexts = new HashSet();
            Map<String, String> workflowMap = this.workflowSchemeManager.getWorkflowMap(project);
            for (Map.Entry<String, String> entry : workflowMap.entrySet()) {
                boolean typeAdded;
                String issueType = entry.getKey();
                String workflowName = entry.getValue();
                Boolean cachedResult = (Boolean)resultCache.get(workflowName);
                if (cachedResult != null) {
                    typeAdded = cachedResult;
                } else {
                    typeAdded = this.checkWorkflow(equality, ids, project, issueType, workflowName);
                    resultCache.put(workflowName, typeAdded);
                }
                if (typeAdded) {
                    projectIssueTypeContexts.addAll(this.getContextsForIssueType(project, workflowMap, issueType));
                    projectAdded = true;
                    continue;
                }
                allIssueTypesAcrossAllProjects = false;
                allIssueTypesAcrossProject = false;
            }
            if (allIssueTypesAcrossProject) {
                projectIssueTypeContexts = Collections.singleton(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), AllIssueTypesContext.INSTANCE));
            }
            if (!projectAdded) {
                allProjects = false;
            }
            allContexts.addAll(projectIssueTypeContexts);
        }
        if (allProjects && allIssueTypesAcrossAllProjects) {
            return Collections.singleton(ProjectIssueTypeContextImpl.createGlobalContext());
        }
        return allContexts;
    }

    private Set<ProjectIssueTypeContext> getContextsForIssueType(Project project, Map<String, String> schemeMap, String issueType) {
        if (issueType == null) {
            HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
            Collection<IssueType> projectTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
            for (IssueType projectType : projectTypes) {
                if (projectType == null || schemeMap.containsKey(projectType.getId())) continue;
                contexts.add(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), new IssueTypeContextImpl(projectType.getId())));
            }
            return contexts;
        }
        return Collections.singleton(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), new IssueTypeContextImpl(issueType)));
    }

    private boolean checkWorkflow(boolean equality, Set<String> ids, Project project, String issueType, String workflowName) {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow != null) {
            List<Status> statusObjects = workflow.getLinkedStatusObjects();
            for (Status statusObject : statusObjects) {
                if (statusObject != null) {
                    if (equality != ids.contains(statusObject.getId())) continue;
                    return true;
                }
                String issueTypeStr = issueType == null ? "default" : issueType;
                log.info((Object)("Workflow: '" + workflow.getName() + "' associated with project: '" + project.getId() + "' and issue type: '" + issueTypeStr + "' contains a null status, you might want to fix that."));
            }
        }
        return false;
    }

    Set<String> getIds(User searcher, TerminalClause clause) {
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, clause.getOperand(), clause);
        HashSet<String> ids = new HashSet<String>();
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.getLongValue() != null) {
                    ids.addAll(this.issueConstantInfoResolver.getIndexedValues(literal.getLongValue()));
                    continue;
                }
                if (literal.getStringValue() != null) {
                    ids.addAll(this.issueConstantInfoResolver.getIndexedValues(literal.getStringValue()));
                    continue;
                }
                if (!literal.isEmpty()) continue;
            }
        }
        return ids;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private boolean isEqualityOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IS || operator == Operator.IN;
    }
}

