/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class SelectCustomFieldClauseContextFactory
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomField customField;
    private final ContextSetUtil contextSetUtil;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;
    private final OperatorUsageValidator operatorUsageValidator;

    public SelectCustomFieldClauseContextFactory(CustomField customField, ContextSetUtil contextSetUtil, JqlSelectOptionsUtil jqlSelectOptionsUtil, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, JqlOperandResolver jqlOperandResolver, OperatorUsageValidator operatorUsageValidator) {
        this.operatorUsageValidator = Assertions.notNull("operatorUsageValidator", operatorUsageValidator);
        this.customField = Assertions.notNull("customField", customField);
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.jqlSelectOptionsUtil = Assertions.notNull("jqlSelectOptionsUtil", jqlSelectOptionsUtil);
        this.fieldConfigSchemeClauseContextUtil = Assertions.notNull("fieldConfigSchemeClauseContextUtil", fieldConfigSchemeClauseContextUtil);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    public final ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        boolean includeAll;
        Set<Object> literalOptions;
        List<FieldConfigScheme> fieldConfigSchemes = this.customField.getConfigurationSchemes();
        if (fieldConfigSchemes == null || fieldConfigSchemes.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Operator operator = terminalClause.getOperator();
        if (this.handlesOperator(operator) && this.operatorUsageValidator.check(searcher, terminalClause)) {
            literalOptions = this.getContextOptions(searcher, terminalClause);
            literalOptions.remove(null);
            includeAll = literalOptions.isEmpty();
        } else {
            literalOptions = Collections.emptySet();
            includeAll = true;
        }
        boolean positiveOperator = this.isPositiveOperator(operator);
        ClauseContext context = new ClauseContextImpl();
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            if (!includeAll && !this.matchesOptions(positiveOperator, fieldConfigScheme, literalOptions)) continue;
            if (fieldConfigScheme.isGlobal()) {
                return ClauseContextImpl.createGlobalClauseContext();
            }
            ClauseContext configContext = this.fieldConfigSchemeClauseContextUtil.getContextForConfigScheme(searcher, fieldConfigScheme);
            context = this.contextSetUtil.union(CollectionBuilder.newBuilder(context, configContext).asSet());
        }
        return context.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : context;
    }

    private Set<Option> getContextOptions(User searcher, TerminalClause terminalClause) {
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals != null && !literals.isEmpty()) {
            LinkedHashSet<Option> literalOptions = new LinkedHashSet<Option>();
            for (QueryLiteral literal : literals) {
                literalOptions.addAll(this.jqlSelectOptionsUtil.getOptions(this.customField, literal, false));
            }
            return literalOptions;
        }
        return Collections.emptySet();
    }

    private boolean matchesOptions(boolean positiveOperator, FieldConfigScheme fieldConfigScheme, Collection<Option> literalOptions) {
        if (positiveOperator) {
            return this.schemeContainsOptions(fieldConfigScheme, literalOptions);
        }
        return this.schemeContainsOtherOptions(fieldConfigScheme, literalOptions);
    }

    private boolean schemeContainsOtherOptions(FieldConfigScheme fieldConfigScheme, Collection<Option> options) {
        List<Option> allOptions = this.jqlSelectOptionsUtil.getOptionsForScheme(fieldConfigScheme);
        return !options.containsAll(allOptions);
    }

    private boolean schemeContainsOptions(FieldConfigScheme fieldConfigScheme, Collection<Option> options) {
        HashSet<Option> schemeOptions = new HashSet<Option>(this.jqlSelectOptionsUtil.getOptionsForScheme(fieldConfigScheme));
        return CollectionUtils.containsAny(schemeOptions, options);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    private boolean isPositiveOperator(Operator operator) {
        return Operator.EQUALS == operator || Operator.IN == operator || Operator.IS == operator;
    }
}

