/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.QueryContextVisitor;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.SavedFilterResolver;
import com.atlassian.jira.jql.validator.SavedFilterCycleDetector;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.List;

@InjectableComponent
public class SavedFilterClauseContextFactory
implements ClauseContextFactory {
    private final SavedFilterResolver savedFilterResolver;
    private final JqlOperandResolver jqlOperandResolver;
    private final QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory;
    private final ContextSetUtil contextSetUtil;
    private final SavedFilterCycleDetector savedFilterCycleDetector;

    public SavedFilterClauseContextFactory(SavedFilterResolver savedFilterResolver, JqlOperandResolver jqlOperandResolver, QueryContextVisitor.QueryContextVisitorFactory queryContextVisitorFactory, ContextSetUtil contextSetUtil, SavedFilterCycleDetector savedFilterCycleDetector) {
        this.savedFilterResolver = savedFilterResolver;
        this.jqlOperandResolver = jqlOperandResolver;
        this.queryContextVisitorFactory = queryContextVisitorFactory;
        this.contextSetUtil = contextSetUtil;
        this.savedFilterCycleDetector = savedFilterCycleDetector;
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext context = null;
        List<QueryLiteral> values = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        List<SearchRequest> requests = this.savedFilterResolver.getSearchRequest(searcher, values);
        boolean equalsOperator = this.isEqualsOperator(operator);
        for (SearchRequest request : requests) {
            ClauseContext subContext;
            Clause subClause;
            if (this.savedFilterCycleDetector.containsSavedFilterReference(searcher, false, request, null)) {
                return ClauseContextImpl.createGlobalClauseContext();
            }
            Query query = request.getQuery();
            if (equalsOperator) {
                subClause = query.getWhereClause();
                subContext = this.getSavedFilterContext(searcher, subClause);
                if (context == null) {
                    context = subContext;
                    continue;
                }
                context = this.contextSetUtil.union(CollectionBuilder.newBuilder(context, subContext).asSet());
                continue;
            }
            subClause = null;
            if (query.getWhereClause() != null) {
                subClause = new NotClause(query.getWhereClause());
            }
            subContext = this.getSavedFilterContext(searcher, subClause);
            if (context == null) {
                context = subContext;
                continue;
            }
            context = this.contextSetUtil.intersect(CollectionBuilder.newBuilder(context, subContext).asSet());
        }
        return context == null ? ClauseContextImpl.createGlobalClauseContext() : context;
    }

    private boolean isEqualsOperator(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS.contains((Object)operator);
    }

    ClauseContext getSavedFilterContext(User searcher, Clause subClause) {
        if (subClause == null) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        QueryContextVisitor visitor = this.queryContextVisitorFactory.createVisitor(searcher);
        ClauseContext fullContext = subClause.accept(visitor).getFullContext();
        if (fullContext == null) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        return fullContext;
    }
}

