/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.clause.DeMorgansVisitor;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@NonInjectableComponent
public class QueryContextVisitor
implements ClauseVisitor<ContextResult> {
    private final User searcher;
    private final ContextSetUtil contextSetUtil;
    private final SearchHandlerManager searchHandlerManager;
    private boolean rootClause = true;

    public QueryContextVisitor(User searcher, ContextSetUtil contextSetUtil, SearchHandlerManager searchHandlerManager) {
        this.searcher = searcher;
        this.contextSetUtil = contextSetUtil;
        this.searchHandlerManager = searchHandlerManager;
    }

    public ContextResult createContext(Clause clause) {
        this.rootClause = false;
        Clause normalisedClause = clause.accept(new DeMorgansVisitor());
        ContextResult result = normalisedClause.accept(this);
        this.rootClause = true;
        return this.replaceEmptyContextsWithGlobal(result);
    }

    private ContextResult replaceEmptyContextsWithGlobal(ContextResult result) {
        ClauseContext fullContext = result.fullContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : result.fullContext;
        ClauseContext simpleContext = result.simpleContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : result.simpleContext;
        return new ContextResult(fullContext, simpleContext);
    }

    @Override
    public ContextResult visit(AndClause andClause) {
        if (this.rootClause) {
            return this.createContext(andClause);
        }
        HashSet<ClauseContext> fullChildClauseContexts = new HashSet<ClauseContext>();
        HashSet<ClauseContext> simpleChildClauseContexts = new HashSet<ClauseContext>();
        List<Clause> childClauses = andClause.getClauses();
        for (Clause childClause : childClauses) {
            ContextResult result = childClause.accept(this);
            fullChildClauseContexts.add(result.getFullContext());
            simpleChildClauseContexts.add(result.getSimpleContext());
        }
        return this.createIntersectionResult(fullChildClauseContexts, simpleChildClauseContexts);
    }

    @Override
    public ContextResult visit(NotClause notClause) {
        if (this.rootClause) {
            return this.createContext(notClause);
        }
        throw new IllegalStateException("We have removed all the NOT clauses from the query, this should never occur.");
    }

    @Override
    public ContextResult visit(OrClause orClause) {
        if (this.rootClause) {
            return this.createContext(orClause);
        }
        HashSet<ClauseContext> fullChildClauseContexts = new HashSet<ClauseContext>();
        HashSet<ClauseContext> simpleChildClauseContexts = new HashSet<ClauseContext>();
        List<Clause> childClauses = orClause.getClauses();
        for (Clause childClause : childClauses) {
            ContextResult result = childClause.accept(this);
            fullChildClauseContexts.add(result.getFullContext());
            simpleChildClauseContexts.add(result.getSimpleContext());
        }
        return this.createUnionResult(fullChildClauseContexts, simpleChildClauseContexts);
    }

    @Override
    public ContextResult visit(TerminalClause clause) {
        if (this.rootClause) {
            return this.createContext(clause);
        }
        String clauseName = clause.getName();
        Collection<ClauseHandler> handlers = this.searchHandlerManager.getClauseHandler(this.searcher, clauseName);
        HashSet<ClauseContext> fullClauseContexts = new HashSet<ClauseContext>();
        HashSet<ClauseContext> simpleClauseContexts = new HashSet<ClauseContext>();
        boolean explicit = this.isExplict(clause);
        for (ClauseHandler clauseHandler : handlers) {
            ClauseContext context = clauseHandler.getClauseContextFactory().getClauseContext(this.searcher, clause);
            if (context.getContexts().isEmpty()) continue;
            fullClauseContexts.add(context);
            if (explicit) {
                simpleClauseContexts.add(context);
                continue;
            }
            simpleClauseContexts.add(ClauseContextImpl.createGlobalClauseContext());
        }
        return this.createUnionResult(fullClauseContexts, simpleClauseContexts);
    }

    @Override
    public ContextResult visit(WasClause clause) {
        return new ContextResult(ClauseContextImpl.createGlobalClauseContext(), ClauseContextImpl.createGlobalClauseContext());
    }

    @Override
    public ContextResult visit(ChangedClause clause) {
        return new ContextResult(ClauseContextImpl.createGlobalClauseContext(), ClauseContextImpl.createGlobalClauseContext());
    }

    private boolean isExplict(TerminalClause clause) {
        return SystemSearchConstants.forProject().getJqlClauseNames().contains(clause.getName()) || SystemSearchConstants.forIssueType().getJqlClauseNames().contains(clause.getName());
    }

    private ContextResult createUnionResult(Set<? extends ClauseContext> fullContexts, Set<? extends ClauseContext> simpleContexts) {
        ClauseContext fullContext = this.safeUnion(fullContexts);
        ClauseContext simpleContext = ((Object)fullContexts).equals(simpleContexts) ? fullContext : this.safeUnion(simpleContexts);
        return new ContextResult(fullContext, simpleContext);
    }

    private ContextResult createIntersectionResult(Set<? extends ClauseContext> fullContexts, Set<? extends ClauseContext> simpleContexts) {
        ClauseContext fullContext = this.safeIntersection(fullContexts);
        ClauseContext simpleContext = ((Object)fullContexts).equals(simpleContexts) ? fullContext : this.safeIntersection(simpleContexts);
        return new ContextResult(fullContext, simpleContext);
    }

    private ClauseContext safeUnion(Set<? extends ClauseContext> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext returnContext = contexts.size() == 1 ? contexts.iterator().next() : this.contextSetUtil.union(contexts);
        return returnContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : returnContext;
    }

    private ClauseContext safeIntersection(Set<? extends ClauseContext> contexts) {
        if (contexts == null || contexts.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext returnContext = contexts.size() == 1 ? contexts.iterator().next() : this.contextSetUtil.intersect(contexts);
        return returnContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : returnContext;
    }

    public static class ContextResult {
        private final ClauseContext fullContext;
        private final ClauseContext simpleContext;

        public ContextResult(ClauseContext fullContext, ClauseContext simpleContext) {
            this.fullContext = fullContext;
            this.simpleContext = simpleContext;
        }

        public ClauseContext getFullContext() {
            return this.fullContext;
        }

        public ClauseContext getSimpleContext() {
            return this.simpleContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextResult that = (ContextResult)o;
            if (this.simpleContext != null ? !this.simpleContext.equals(that.simpleContext) : that.simpleContext != null) {
                return false;
            }
            return !(this.fullContext != null ? !this.fullContext.equals(that.fullContext) : that.fullContext != null);
        }

        public int hashCode() {
            int result = this.fullContext != null ? this.fullContext.hashCode() : 0;
            result = 31 * result + (this.simpleContext != null ? this.simpleContext.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.format("[Complex: %s, Simple: %s]", this.fullContext, this.simpleContext);
        }
    }

    @InjectableComponent
    public static class QueryContextVisitorFactory {
        private final ContextSetUtil contextSetUtil;
        private final SearchHandlerManager searchHandlerManager;

        public QueryContextVisitorFactory(ContextSetUtil contextSetUtil, SearchHandlerManager searchHandlerManager) {
            this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
            this.searchHandlerManager = Assertions.notNull("searchHandlerManager", searchHandlerManager);
        }

        public QueryContextVisitor createVisitor(User searcher) {
            return new QueryContextVisitor(searcher, this.contextSetUtil, this.searchHandlerManager);
        }
    }
}

