/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.ProjectIndexInfoResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProjectClauseContextFactory
implements ClauseContextFactory {
    private final PermissionManager permissionManager;
    private final ProjectIndexInfoResolver projectIndexInfoResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public ProjectClauseContextFactory(JqlOperandResolver jqlOperandResolver, NameResolver<Project> projectResolver, PermissionManager permissionManager) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.permissionManager = permissionManager;
        this.projectIndexInfoResolver = new ProjectIndexInfoResolver(projectResolver);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> values = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        Set<Project> projectsInContext = this.getProjectsInContext(values, searcher, this.isNegationOperator(operator));
        if (projectsInContext.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
        for (Project project : projectsInContext) {
            contexts.add(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), AllIssueTypesContext.INSTANCE));
        }
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    private Set<Project> getProjectsInContext(List<QueryLiteral> values, User searcher, boolean negationOperator) {
        HashSet<String> projectIds = new HashSet<String>();
        if (values != null) {
            for (QueryLiteral value : values) {
                if (value.getStringValue() != null) {
                    projectIds.addAll(this.projectIndexInfoResolver.getIndexedValues(value.getStringValue()));
                    continue;
                }
                if (value.getLongValue() != null) {
                    projectIds.addAll(this.projectIndexInfoResolver.getIndexedValues(value.getLongValue()));
                    continue;
                }
                if (value.isEmpty()) continue;
                throw new IllegalStateException("Invalid query literal");
            }
        }
        if (projectIds.isEmpty()) {
            return Collections.emptySet();
        }
        Collection<Project> visibleProjects = this.permissionManager.getProjectObjects(10, searcher);
        HashSet<Project> projectsInContext = new HashSet<Project>();
        for (Project visibleProject : visibleProjects) {
            if (!(projectIds.contains(visibleProject.getId().toString()) ^ negationOperator)) continue;
            projectsInContext.add(visibleProject);
        }
        return projectsInContext;
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains((Object)operator);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }
}

