/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ProjectCategoryResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

@InjectableComponent
public class ProjectCategoryClauseContextFactory
implements ClauseContextFactory {
    private final PermissionManager permissionManager;
    private final ProjectCategoryResolver projectCategoryResolver;
    private final JqlOperandResolver jqlOperandResolver;

    public ProjectCategoryClauseContextFactory(PermissionManager permissionManager, ProjectCategoryResolver projectCategoryResolver, JqlOperandResolver jqlOperandResolver) {
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
        this.projectCategoryResolver = Assertions.notNull("projectCategoryResolver", projectCategoryResolver);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set<Project> associatedProjects = this.getAssociatedProjectsFromClause(searcher, terminalClause);
        Set<ProjectIssueTypeContext> contexts = this.getContextsForProjects(associatedProjects);
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    private Set<Project> getAssociatedProjectsFromClause(User searcher, TerminalClause clause) {
        LinkedHashSet<QueryLiteral> rawValues;
        HashSet<Project> allVisibleProjects = new HashSet<Project>(this.permissionManager.getProjectObjects(10, searcher));
        HashSet<Project> associatedProjects = new HashSet<Project>();
        List<QueryLiteral> list = this.jqlOperandResolver.getValues(searcher, clause.getOperand(), clause);
        LinkedHashSet<QueryLiteral> linkedHashSet = rawValues = list != null ? new LinkedHashSet<QueryLiteral>(list) : new LinkedHashSet();
        if (this.isNegationOperator(clause.getOperator())) {
            rawValues.add(new QueryLiteral());
        }
        for (QueryLiteral rawValue : rawValues) {
            Collection<Project> projectsForCategory = this.projectCategoryResolver.getProjectsForCategory(rawValue);
            associatedProjects.addAll(CollectionUtils.intersection(allVisibleProjects, projectsForCategory));
        }
        if (!associatedProjects.isEmpty() && this.isNegationOperator(clause.getOperator())) {
            allVisibleProjects.removeAll(associatedProjects);
            associatedProjects = allVisibleProjects;
        }
        return associatedProjects;
    }

    private Set<ProjectIssueTypeContext> getContextsForProjects(Collection<Project> projects) {
        CollectionBuilder<ProjectIssueTypeContextImpl> builder = CollectionBuilder.newBuilder();
        for (Project project : projects) {
            builder.add(new ProjectIssueTypeContextImpl(new ProjectContextImpl(project.getId()), AllIssueTypesContext.INSTANCE));
        }
        return builder.asMutableSet();
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains((Object)operator);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }
}

