/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.jql.context.AllProjectsContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.IssueTypeResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.HashSet;
import java.util.List;

public class IssueTypeClauseContextFactory
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final IssueConstantInfoResolver<IssueType> resolver;
    private final ConstantsManager constantsManager;

    public IssueTypeClauseContextFactory(IssueTypeResolver issueTypeResolver, JqlOperandResolver jqlOperandResolver, ConstantsManager constantsManager) {
        this.constantsManager = Assertions.notNull("constantsManager", constantsManager);
        this.resolver = new IssueConstantInfoResolver(Assertions.notNull("issueTypeResolver", issueTypeResolver));
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> values = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        HashSet<String> issueTypeIds = new HashSet<String>();
        if (values != null) {
            for (QueryLiteral value : values) {
                if (value.isEmpty()) continue;
                issueTypeIds.addAll(this.getIds(value));
            }
        }
        if (!issueTypeIds.isEmpty() && this.isNegationOperator(operator)) {
            HashSet<String> allIssueTypes = new HashSet<String>(this.constantsManager.getAllIssueTypeIds());
            allIssueTypes.removeAll(issueTypeIds);
            issueTypeIds = allIssueTypes;
        }
        if (issueTypeIds.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
        for (String issueTypeId : issueTypeIds) {
            contexts.add(new ProjectIssueTypeContextImpl(AllProjectsContext.INSTANCE, new IssueTypeContextImpl(issueTypeId)));
        }
        return new ClauseContextImpl(contexts);
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains((Object)operator);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }

    List<String> getIds(QueryLiteral value) {
        if (value.getStringValue() != null) {
            return this.resolver.getIndexedValues(value.getStringValue());
        }
        if (value.getLongValue() != null) {
            return this.resolver.getIndexedValues(value.getLongValue());
        }
        throw new IllegalStateException("Invalid query literal.");
    }
}

