/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ComponentIndexInfoResolver;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ComponentClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<ProjectComponent> {
    private final JqlOperandResolver jqlOperandResolver;
    private final ComponentResolver componentResolver;
    private final ProjectManager projectManager;

    public ComponentClauseContextFactory(JqlOperandResolver jqlOperandResolver, ComponentResolver componentResolver, ProjectManager projectManager, PermissionManager permissionManager) {
        super(new ComponentIndexInfoResolver(componentResolver), jqlOperandResolver, permissionManager);
        this.projectManager = Assertions.notNull("projectManager", projectManager);
        this.componentResolver = Assertions.notNull("componentResolver", componentResolver);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    ClauseContext getContextFromClause(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        ArrayList<ProjectComponent> specifiedComponents = new ArrayList<ProjectComponent>();
        if (literals != null) {
            for (QueryLiteral literal : literals) {
                if (literal.isEmpty()) continue;
                List<Long> ids = this.getIds(literal);
                for (Long id : ids) {
                    specifiedComponents.add(this.componentResolver.get(id));
                }
            }
        }
        if (!specifiedComponents.isEmpty()) {
            ArrayList<ProjectComponent> contextComponents = new ArrayList<ProjectComponent>();
            if (this.isNegationOperator(operator)) {
                ArrayList<ProjectComponent> allComponents = new ArrayList<ProjectComponent>(this.componentResolver.getAll());
                allComponents.removeAll(specifiedComponents);
                contextComponents.addAll(allComponents);
            } else {
                contextComponents = specifiedComponents;
            }
            HashSet<ProjectIssueTypeContext> contexts = new HashSet<ProjectIssueTypeContext>();
            for (ProjectComponent contextComponent : contextComponents) {
                contexts.addAll(this.getContextsForProject(searcher, this.getProject(contextComponent.getProjectId())));
            }
            return new ClauseContextImpl(contexts);
        }
        return ClauseContextImpl.createGlobalClauseContext();
    }

    private Project getProject(Long projectId) {
        return this.projectManager.getProjectObj(projectId);
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }
}

