/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ContextSetUtil;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

@NonInjectableComponent
public class CascadingSelectCustomFieldClauseContextFactory
implements ClauseContextFactory {
    private final JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomField customField;
    private final ContextSetUtil contextSetUtil;
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;
    private final OperatorUsageValidator operatorUsageValidator;

    public CascadingSelectCustomFieldClauseContextFactory(CustomField customField, ContextSetUtil contextSetUtil, JqlSelectOptionsUtil jqlSelectOptionsUtil, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, JqlOperandResolver jqlOperandResolver, JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil, OperatorUsageValidator operatorUsageValidator) {
        this.operatorUsageValidator = Assertions.notNull("operatorUsageValidator", operatorUsageValidator);
        this.customField = Assertions.notNull("customField", customField);
        this.contextSetUtil = Assertions.notNull("contextSetUtil", contextSetUtil);
        this.jqlSelectOptionsUtil = Assertions.notNull("jqlSelectOptionsUtil", jqlSelectOptionsUtil);
        this.fieldConfigSchemeClauseContextUtil = Assertions.notNull("fieldConfigSchemeClauseContextUtil", fieldConfigSchemeClauseContextUtil);
        this.jqlCascadingSelectLiteralUtil = Assertions.notNull("jqlCascadingSelectLiteralUtil", jqlCascadingSelectLiteralUtil);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
    }

    @Override
    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        boolean includeAll;
        List<FieldConfigScheme> fieldConfigSchemes = this.customField.getConfigurationSchemes();
        if (fieldConfigSchemes == null || fieldConfigSchemes.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        HashSet<Option> positiveOps = new HashSet<Option>();
        HashSet<Option> negativeOps = new HashSet<Option>();
        Operator operator = terminalClause.getOperator();
        boolean positiveOperator = this.isPositiveOperator(operator);
        if (this.handlesOperator(operator) && this.operatorUsageValidator.check(searcher, terminalClause)) {
            this.fillOptions(searcher, terminalClause, positiveOps, negativeOps);
            negativeOps.remove(null);
            positiveOps.remove(null);
            includeAll = positiveOperator ? positiveOps.isEmpty() : positiveOps.isEmpty() && negativeOps.isEmpty();
        } else {
            includeAll = true;
        }
        HashSet<ClauseContext> contexts = new HashSet<ClauseContext>();
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            if (!includeAll && !this.matchesOptions(positiveOperator, fieldConfigScheme, positiveOps, negativeOps)) continue;
            if (fieldConfigScheme.isGlobal()) {
                return ClauseContextImpl.createGlobalClauseContext();
            }
            contexts.add(this.fieldConfigSchemeClauseContextUtil.getContextForConfigScheme(searcher, fieldConfigScheme));
        }
        if (contexts.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        ClauseContext calcContext = contexts.size() == 1 ? (ClauseContext)contexts.iterator().next() : this.contextSetUtil.union(contexts);
        return calcContext.getContexts().isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : calcContext;
    }

    private boolean matchesOptions(boolean positiveOperator, FieldConfigScheme fieldConfigScheme, Set<Option> positiveOps, Set<Option> negativeOps) {
        if (positiveOperator) {
            return this.matchesOptionsPositive(fieldConfigScheme, positiveOps, negativeOps);
        }
        return this.matchesOptionsNegative(fieldConfigScheme, positiveOps, negativeOps);
    }

    private boolean matchesOptionsNegative(FieldConfigScheme fieldConfigScheme, Set<Option> positiveOps, Set<Option> negativeOps) {
        HashSet<Option> options = new HashSet<Option>(this.jqlSelectOptionsUtil.getOptionsForScheme(fieldConfigScheme));
        if (CollectionUtils.containsAny(options, negativeOps)) {
            return true;
        }
        CascadingSelectCustomFieldClauseContextFactory.removeOptions(options, positiveOps);
        return !options.isEmpty();
    }

    private boolean matchesOptionsPositive(FieldConfigScheme fieldConfigScheme, Set<Option> positiveOps, Set<Option> negativeOps) {
        if (positiveOps.isEmpty()) {
            return false;
        }
        HashSet<Option> options = new HashSet<Option>(this.jqlSelectOptionsUtil.getOptionsForScheme(fieldConfigScheme));
        CascadingSelectCustomFieldClauseContextFactory.removeOptions(options, negativeOps);
        return CollectionUtils.containsAny(options, positiveOps);
    }

    private static void removeOptions(Collection<Option> options, Collection<Option> removeOptions) {
        for (Option remove : removeOptions) {
            options.remove(remove);
            List<Option> list = remove.getChildOptions();
            if (list == null) continue;
            options.removeAll(list);
        }
    }

    void fillOptions(User user, TerminalClause clause, Set<Option> positiveOption, Set<Option> negativeOption) {
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause);
        if (literals == null) {
            return;
        }
        ArrayList<QueryLiteral> positiveLiterals = new ArrayList<QueryLiteral>();
        ArrayList<QueryLiteral> negativeLiterals = new ArrayList<QueryLiteral>();
        this.jqlCascadingSelectLiteralUtil.processPositiveNegativeOptionLiterals(literals, positiveLiterals, negativeLiterals);
        this.fillOptions(positiveLiterals, positiveOption);
        this.fillOptions(negativeLiterals, negativeOption);
    }

    private void fillOptions(Collection<QueryLiteral> literal, Set<Option> options) {
        for (QueryLiteral queryLiteral : literal) {
            options.addAll(this.jqlSelectOptionsUtil.getOptions(this.customField, queryLiteral, true));
        }
    }

    private boolean isPositiveOperator(Operator operator) {
        return Operator.EQUALS == operator || Operator.IN == operator || Operator.IS == operator;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator);
    }
}

