/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.BuilderOperator;
import com.atlassian.jira.jql.builder.MutableClause;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.NotClause;

class NotMutableClause
implements MutableClause {
    private final MutableClause clause;

    NotMutableClause(MutableClause clause) {
        this.clause = Assertions.notNull("clause", clause);
    }

    @Override
    public MutableClause combine(BuilderOperator logicalOperator, MutableClause otherClause) {
        Assertions.notNull("logicalOperator", logicalOperator);
        return logicalOperator.createClauseForOperator(this, otherClause);
    }

    @Override
    public Clause asClause() {
        Clause subclause = this.clause.asClause();
        return subclause == null ? null : new NotClause(subclause);
    }

    @Override
    public MutableClause copy() {
        MutableClause copyClause = this.clause.copy();
        if (copyClause != this.clause) {
            return new NotMutableClause(copyClause);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotMutableClause that = (NotMutableClause)o;
        return this.clause.equals(that.clause);
    }

    public int hashCode() {
        return this.clause.hashCode();
    }

    public String toString() {
        return BuilderOperator.NOT.toString() + '(' + this.clause + ')';
    }
}

