/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.ValueBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

class DefaultValueBuilder
implements ValueBuilder {
    private final JqlClauseBuilder builder;
    private final String clauseName;
    private final Operator operator;

    DefaultValueBuilder(JqlClauseBuilder builder, String clauseName, Operator operator) {
        this.builder = Assertions.notNull("builder", builder);
        this.clauseName = Assertions.notNull("clauseName", clauseName);
        this.operator = Assertions.notNull("operator", operator);
    }

    @Override
    public JqlClauseBuilder string(String value) {
        return this.builder.addStringCondition(this.clauseName, this.operator, value);
    }

    @Override
    public JqlClauseBuilder strings(String ... values) {
        return this.builder.addStringCondition(this.clauseName, this.operator, values);
    }

    @Override
    public JqlClauseBuilder strings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, this.operator, values);
    }

    @Override
    public JqlClauseBuilder number(Long value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    @Override
    public JqlClauseBuilder numbers(Long ... value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    @Override
    public JqlClauseBuilder numbers(Collection<Long> value) {
        return this.builder.addNumberCondition(this.clauseName, this.operator, value);
    }

    @Override
    public JqlClauseBuilder operand(Operand operand) {
        return this.builder.addCondition(this.clauseName, this.operator, operand);
    }

    @Override
    public JqlClauseBuilder operands(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, this.operator, operands);
    }

    @Override
    public JqlClauseBuilder operands(Collection<? extends Operand> operands) {
        return this.builder.addCondition(this.clauseName, this.operator, operands);
    }

    @Override
    public JqlClauseBuilder empty() {
        return this.builder.addCondition(this.clauseName, this.operator, (Operand)EmptyOperand.EMPTY);
    }

    @Override
    public JqlClauseBuilder function(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName);
    }

    @Override
    public JqlClauseBuilder function(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName, args);
    }

    @Override
    public JqlClauseBuilder function(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, this.operator, funcName, args);
    }

    @Override
    public JqlClauseBuilder functionStandardIssueTypes() {
        return this.function("standardIssueTypes");
    }

    @Override
    public JqlClauseBuilder functionSubTaskIssueTypes() {
        return this.function("subTaskIssueTypes");
    }

    @Override
    public JqlClauseBuilder functionMembersOf(String groupName) {
        Assertions.notNull("groupName", groupName);
        return this.function("membersOf", groupName);
    }

    @Override
    public JqlClauseBuilder functionCurrentUser() {
        return this.function("currentUser");
    }

    @Override
    public JqlClauseBuilder functionIssueHistory() {
        return this.function("issueHistory");
    }

    @Override
    public JqlClauseBuilder functionReleasedVersions(String ... projects) {
        return this.function("releasedVersions", projects);
    }

    @Override
    public JqlClauseBuilder functionUnreleasedVersions(String ... projects) {
        return this.function("unreleasedVersions", projects);
    }

    @Override
    public JqlClauseBuilder functionNow() {
        return this.function("now");
    }

    @Override
    public JqlClauseBuilder functionWatchedIssues() {
        return this.function("watchedIssues");
    }

    @Override
    public JqlClauseBuilder functionVotedIssues() {
        return this.function("votedIssues");
    }

    @Override
    public JqlClauseBuilder functionLinkedIssues(String issue, String ... issueLinkTypes) {
        List<String> args;
        Assertions.notNull("issue", issue);
        Assertions.notNull("issueLinkTypes", issueLinkTypes);
        if (issueLinkTypes.length == 0) {
            args = Collections.singletonList(issue);
        } else {
            args = new ArrayList<String>(issueLinkTypes.length + 1);
            args.add(issue);
            args.addAll(Arrays.asList(issueLinkTypes));
        }
        return this.function("linkedIssues", args);
    }

    @Override
    public JqlClauseBuilder functionCascaingOption(String parent) {
        return this.function("cascadeOption", parent);
    }

    @Override
    public JqlClauseBuilder functionCascaingOption(String parent, String child) {
        return this.function("cascadeOption", parent, child);
    }

    @Override
    public JqlClauseBuilder functionCascaingOptionParentOnly(String parent) {
        return this.function("cascadeOption", parent, "\"none\"");
    }

    @Override
    public JqlClauseBuilder functionLastLogin() {
        return this.function("lastLogin");
    }

    @Override
    public JqlClauseBuilder functionCurrentLogin() {
        return this.function("currentLogin");
    }

    @Override
    public JqlClauseBuilder date(Date date) {
        return this.builder.addDateCondition(this.clauseName, this.operator, date);
    }

    @Override
    public JqlClauseBuilder dates(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, this.operator, dates);
    }

    @Override
    public JqlClauseBuilder dates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, this.operator, dates);
    }
}

