/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.DefaultConditionBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.builder.PrecedenceSimpleClauseBuilder;
import com.atlassian.jira.jql.builder.SimpleClauseBuilder;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.Date;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@SuppressWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="TODO Brenden needs to fix this")
class DefaultJqlClauseBuilder
implements JqlClauseBuilder {
    private final JqlQueryBuilder parent;
    private final JqlDateSupport jqlDateSupport;
    private SimpleClauseBuilder builder;

    DefaultJqlClauseBuilder(JqlQueryBuilder parent, SimpleClauseBuilder builder, JqlDateSupport support) {
        this.builder = Assertions.notNull("builder", builder);
        this.jqlDateSupport = Assertions.notNull("support", support);
        this.parent = parent;
    }

    DefaultJqlClauseBuilder(JqlQueryBuilder parent, TimeZoneManager timeZoneManager) {
        this(parent, new PrecedenceSimpleClauseBuilder(), new JqlDateSupportImpl(timeZoneManager));
    }

    DefaultJqlClauseBuilder(TimeZoneManager timeZoneManager) {
        this(null, timeZoneManager);
    }

    @Override
    public JqlClauseBuilder clear() {
        this.builder = this.builder.clear();
        return this;
    }

    @Override
    public JqlQueryBuilder endWhere() {
        return this.parent;
    }

    @Override
    public Query buildQuery() {
        if (this.parent != null) {
            return this.parent.buildQuery();
        }
        return new QueryImpl(this.buildClause());
    }

    @Override
    public JqlClauseBuilder defaultAnd() {
        this.builder = this.builder.defaultAnd();
        return this;
    }

    @Override
    public JqlClauseBuilder defaultOr() {
        this.builder = this.builder.defaultOr();
        return this;
    }

    @Override
    public JqlClauseBuilder defaultNone() {
        this.builder = this.builder.defaultNone();
        return this;
    }

    @Override
    public JqlClauseBuilder and() {
        this.builder = this.builder.and();
        return this;
    }

    @Override
    public JqlClauseBuilder or() {
        this.builder = this.builder.or();
        return this;
    }

    @Override
    public JqlClauseBuilder not() {
        this.builder = this.builder.not();
        return this;
    }

    @Override
    public JqlClauseBuilder sub() {
        this.builder = this.builder.sub();
        return this;
    }

    @Override
    public JqlClauseBuilder endsub() {
        this.builder = this.builder.endsub();
        return this;
    }

    @Override
    public JqlClauseBuilder affectedVersion(String version) {
        return this.addStringCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    @Override
    public JqlClauseBuilder affectedVersion(String ... versons) {
        return this.addStringCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), versons);
    }

    @Override
    public JqlClauseBuilder affectedVersionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder affectedVersion() {
        return new DefaultConditionBuilder(SystemSearchConstants.forAffectedVersion().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder fixVersion(String version) {
        return this.addStringCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    @Override
    public JqlClauseBuilder fixVersion(String ... versions) {
        return this.addStringCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), versions);
    }

    @Override
    public JqlClauseBuilder fixVersion(Long version) {
        return this.addNumberCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), version);
    }

    @Override
    public JqlClauseBuilder fixVersion(Long ... versions) {
        return this.addNumberCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), versions);
    }

    @Override
    public JqlClauseBuilder fixVersionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder fixVersion() {
        return new DefaultConditionBuilder(SystemSearchConstants.forFixForVersion().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder priority(String ... priorities) {
        return this.addStringCondition(SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName(), priorities);
    }

    @Override
    public ConditionBuilder priority() {
        return new DefaultConditionBuilder(SystemSearchConstants.forPriority().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder resolution(String ... resolutions) {
        return this.addStringCondition(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), resolutions);
    }

    @Override
    public JqlClauseBuilder unresolved() {
        return this.addCondition(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new SingleValueOperand("Unresolved"));
    }

    @Override
    public ConditionBuilder resolution() {
        return new DefaultConditionBuilder(SystemSearchConstants.forResolution().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder status(String ... statuses) {
        return this.addStringCondition(SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName(), statuses);
    }

    @Override
    public ConditionBuilder status() {
        return new DefaultConditionBuilder(SystemSearchConstants.forStatus().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder issueType(String ... types) {
        return this.addStringCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), types);
    }

    @Override
    public JqlClauseBuilder issueTypeIsStandard() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), Operator.IN, "standardIssueTypes");
    }

    @Override
    public JqlClauseBuilder issueTypeIsSubtask() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), Operator.IN, "subTaskIssueTypes");
    }

    @Override
    public ConditionBuilder issueType() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueType().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder description(String value) {
        return this.addStringCondition(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    @Override
    public JqlClauseBuilder descriptionIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder description() {
        return new DefaultConditionBuilder(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder summary(String value) {
        return this.addStringCondition(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    @Override
    public ConditionBuilder summary() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder environment(String value) {
        return this.addStringCondition(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    @Override
    public JqlClauseBuilder environmentIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder environment() {
        return new DefaultConditionBuilder(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder comment(String value) {
        return this.addStringCondition(SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), Operator.LIKE, value);
    }

    @Override
    public ConditionBuilder comment() {
        return new DefaultConditionBuilder(SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder project(String ... projects) {
        return this.addStringCondition(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), projects);
    }

    @Override
    public JqlClauseBuilder project(Long ... pids) {
        return this.addNumberCondition(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), pids);
    }

    @Override
    public ConditionBuilder project() {
        return new DefaultConditionBuilder(SystemSearchConstants.forProject().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder category(String ... values) {
        return this.addStringCondition(SystemSearchConstants.forProjectCategory().getJqlClauseNames().getPrimaryName(), values);
    }

    @Override
    public ConditionBuilder category() {
        return new DefaultConditionBuilder(SystemSearchConstants.forProjectCategory().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder createdAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder createdAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder createdBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    @Override
    public JqlClauseBuilder createdBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    @Override
    public ConditionBuilder created() {
        return new DefaultConditionBuilder(SystemSearchConstants.forCreatedDate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder updatedAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder updatedAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder updatedBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    @Override
    public JqlClauseBuilder updatedBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    @Override
    public ConditionBuilder updated() {
        return new DefaultConditionBuilder(SystemSearchConstants.forUpdatedDate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder dueAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder dueAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder dueBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    @Override
    public JqlClauseBuilder dueBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    @Override
    public ConditionBuilder due() {
        return new DefaultConditionBuilder(SystemSearchConstants.forDueDate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder resolutionDateAfter(Date startDate) {
        return this.addDateCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder resolutionDateAfter(String startDate) {
        return this.addStringCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), Operator.GREATER_THAN_EQUALS, startDate);
    }

    @Override
    public JqlClauseBuilder resolutionDateBetween(Date startDate, Date endDate) {
        return this.addDateRangeCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), startDate, endDate);
    }

    @Override
    public JqlClauseBuilder resolutionDateBetween(String startDateString, String endDateString) {
        return this.addStringRangeCondition(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), startDateString, endDateString);
    }

    @Override
    public ConditionBuilder resolutionDate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forResolutionDate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder reporterUser(String userName) {
        Assertions.notNull("userName", userName);
        return this.addStringCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), userName);
    }

    @Override
    public JqlClauseBuilder reporterInGroup(String groupName) {
        Assertions.notNull("groupName", groupName);
        return this.addCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", groupName));
    }

    @Override
    public JqlClauseBuilder reporterIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    @Override
    public JqlClauseBuilder reporterIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder reporter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forReporter().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder assigneeUser(String userName) {
        Assertions.notNull("userName", userName);
        return this.addStringCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), userName);
    }

    @Override
    public JqlClauseBuilder assigneeInGroup(String groupName) {
        Assertions.notNull("groupName", groupName);
        return this.addCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", groupName));
    }

    @Override
    public JqlClauseBuilder assigneeIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    @Override
    public JqlClauseBuilder assigneeIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder assignee() {
        return new DefaultConditionBuilder(SystemSearchConstants.forAssignee().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder component(String ... components) {
        return this.addStringCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), components);
    }

    @Override
    public JqlClauseBuilder component(Long ... components) {
        return this.addNumberCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), components);
    }

    @Override
    public JqlClauseBuilder componentIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder component() {
        return new DefaultConditionBuilder(SystemSearchConstants.forComponent().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder labels() {
        return new DefaultConditionBuilder(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder labels(String ... labels) {
        return this.addStringCondition(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), labels);
    }

    @Override
    public JqlClauseBuilder labelsIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public JqlClauseBuilder issue(String ... keys) {
        return this.addStringCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, keys);
    }

    @Override
    public JqlClauseBuilder issueInHistory() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "issueHistory");
    }

    @Override
    public JqlClauseBuilder issueInWatchedIssues() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "watchedIssues");
    }

    @Override
    public JqlClauseBuilder issueInVotedIssues() {
        return this.addFunctionCondition(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), Operator.IN, "votedIssues");
    }

    @Override
    public ConditionBuilder issue() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueKey().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder issueParent(String ... keys) {
        return this.addStringCondition(SystemSearchConstants.forIssueParent().getJqlClauseNames().getPrimaryName(), Operator.IN, keys);
    }

    @Override
    public ConditionBuilder issueParent() {
        return new DefaultConditionBuilder(SystemSearchConstants.forIssueParent().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder currentEstimate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forCurrentEstimate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder originalEstimate() {
        return new DefaultConditionBuilder(SystemSearchConstants.forOriginalEstimate().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder timeSpent() {
        return new DefaultConditionBuilder(SystemSearchConstants.forTimeSpent().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder workRatio() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWorkRatio().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder level(String ... levels) {
        return this.addStringCondition(SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName(), Operator.IN, levels);
    }

    @Override
    public ConditionBuilder level() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSecurityLevel().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder savedFilter(String ... filters) {
        return this.addStringCondition(SystemSearchConstants.forSavedFilter().getJqlClauseNames().getPrimaryName(), Operator.IN, filters);
    }

    @Override
    public ConditionBuilder savedFilter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forSavedFilter().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder votes() {
        return new DefaultConditionBuilder(SystemSearchConstants.forVotes().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder watches() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWatches().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder voterUser(String userName) {
        Assertions.notNull("userName", userName);
        return this.addStringCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), userName);
    }

    @Override
    public JqlClauseBuilder voterInGroup(String groupName) {
        Assertions.notNull("groupName", groupName);
        return this.addCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", groupName));
    }

    @Override
    public JqlClauseBuilder voterIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    @Override
    public JqlClauseBuilder voterIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder voter() {
        return new DefaultConditionBuilder(SystemSearchConstants.forVoters().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public JqlClauseBuilder watcherUser(String userName) {
        Assertions.notNull("userName", userName);
        return this.addStringCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), userName);
    }

    @Override
    public JqlClauseBuilder watcherInGroup(String groupName) {
        Assertions.notNull("groupName", groupName);
        return this.addCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), Operator.IN, (Operand)new FunctionOperand("membersOf", groupName));
    }

    @Override
    public JqlClauseBuilder watcherIsCurrentUser() {
        return this.addCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), Operator.EQUALS, (Operand)new FunctionOperand("currentUser"));
    }

    @Override
    public JqlClauseBuilder watcherIsEmpty() {
        return this.addEmptyCondition(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName());
    }

    @Override
    public ConditionBuilder watcher() {
        return new DefaultConditionBuilder(SystemSearchConstants.forWatchers().getJqlClauseNames().getPrimaryName(), this);
    }

    @Override
    public ConditionBuilder field(String jqlName) {
        Assertions.notNull("jqlName", jqlName);
        return new DefaultConditionBuilder(jqlName, this);
    }

    @Override
    public ConditionBuilder customField(Long id) {
        Assertions.notNull("id", id);
        return new DefaultConditionBuilder(JqlCustomFieldId.toString(id), this);
    }

    @Override
    public JqlClauseBuilder addClause(Clause clause) {
        Assertions.notNull("clause", clause);
        this.builder = this.builder.clause(clause);
        return this;
    }

    @Override
    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Date date) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("date", date);
        return this.addTerminalClause(clauseName, operator, new SingleValueOperand(this.jqlDateSupport.getDateString(date)));
    }

    @Override
    public JqlClauseBuilder addDateCondition(String clauseName, Date ... dates) {
        if (dates != null && dates.length == 1) {
            return this.addDateCondition(clauseName, Operator.EQUALS, dates[0]);
        }
        return this.addDateCondition(clauseName, Operator.IN, dates);
    }

    @Override
    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Date ... dates) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("dates", dates);
        Assertions.not("dates is empty", dates.length == 0);
        String[] args = new String[dates.length];
        int position = 0;
        for (Date date : dates) {
            args[position++] = this.jqlDateSupport.getDateString(date);
        }
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(args));
    }

    @Override
    public JqlClauseBuilder addDateCondition(String clauseName, Collection<Date> dates) {
        if (dates != null && dates.size() == 1) {
            return this.addDateCondition(clauseName, Operator.EQUALS, dates.iterator().next());
        }
        return this.addDateCondition(clauseName, Operator.IN, dates);
    }

    @Override
    public JqlClauseBuilder addDateCondition(String clauseName, Operator operator, Collection<Date> dates) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("dates", dates);
        Assertions.not("dates is empty", dates.isEmpty());
        String[] args = new String[dates.size()];
        int position = 0;
        for (Date date : dates) {
            args[position++] = this.jqlDateSupport.getDateString(date);
        }
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(args));
    }

    @Override
    public JqlClauseBuilder addDateRangeCondition(String clauseName, Date startDate, Date endDate) {
        SingleValueOperand startOperand = startDate == null ? null : new SingleValueOperand(this.jqlDateSupport.getDateString(startDate));
        SingleValueOperand endOperand = endDate == null ? null : new SingleValueOperand(this.jqlDateSupport.getDateString(endDate));
        return this.addRangeCondition(clauseName, startOperand, endOperand);
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName);
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName, String ... args) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName, args);
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, String functionName, Collection<String> args) {
        return this.addFunctionCondition(clauseName, Operator.EQUALS, functionName, args);
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("functionName", functionName);
        return this.addTerminalClause(clauseName, operator, new FunctionOperand(functionName));
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName, String ... args) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("functionName", functionName);
        Assertions.containsNoNulls("args", args);
        return this.addTerminalClause(clauseName, operator, new FunctionOperand(functionName, args));
    }

    @Override
    public JqlClauseBuilder addFunctionCondition(String clauseName, Operator operator, String functionName, Collection<String> args) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("functionName", functionName);
        Assertions.containsNoNulls("args", args);
        return this.addTerminalClause(clauseName, operator, new FunctionOperand(functionName, args));
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, String clauseValue) {
        return this.addStringCondition(clauseName, Operator.EQUALS, clauseValue);
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, String ... clauseValues) {
        if (clauseValues != null && clauseValues.length == 1) {
            return this.addStringCondition(clauseName, Operator.EQUALS, clauseValues[0]);
        }
        return this.addStringCondition(clauseName, Operator.IN, clauseValues);
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, Collection<String> clauseValues) {
        if (clauseValues != null && clauseValues.size() == 1) {
            return this.addStringCondition(clauseName, Operator.EQUALS, clauseValues.iterator().next());
        }
        return this.addStringCondition(clauseName, Operator.IN, clauseValues);
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, String clauseValue) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("clauseValue", clauseValue);
        return this.addTerminalClause(clauseName, operator, new SingleValueOperand(clauseValue));
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, String ... clauseValues) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("clauseValues", clauseValues);
        Assertions.not("clauseValues is empty", clauseValues.length == 0);
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(clauseValues));
    }

    @Override
    public JqlClauseBuilder addStringCondition(String clauseName, Operator operator, Collection<String> clauseValues) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("clauseValues", clauseValues);
        Assertions.not("clauseValues is empty", clauseValues.isEmpty());
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(clauseValues.toArray(new String[clauseValues.size()])));
    }

    @Override
    public JqlClauseBuilder addStringRangeCondition(String clauseName, String start, String end) {
        SingleValueOperand startClause = start == null ? null : new SingleValueOperand(start);
        SingleValueOperand endClause = end == null ? null : new SingleValueOperand(end);
        return this.addRangeCondition(clauseName, startClause, endClause);
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Long clauseValue) {
        return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValue);
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Long ... clauseValues) {
        if (clauseValues != null && clauseValues.length == 1) {
            return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValues[0]);
        }
        return this.addNumberCondition(clauseName, Operator.IN, clauseValues);
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Collection<Long> clauseValues) {
        if (clauseValues != null && clauseValues.size() == 1) {
            return this.addNumberCondition(clauseName, Operator.EQUALS, clauseValues.iterator().next());
        }
        return this.addNumberCondition(clauseName, Operator.IN, clauseValues);
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Long clauseValue) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("clauseValue", clauseValue);
        return this.addTerminalClause(clauseName, operator, new SingleValueOperand(clauseValue));
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Long ... clauseValues) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("clauseValues", clauseValues);
        Assertions.not("clauseValues is empty", clauseValues.length == 0);
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(clauseValues));
    }

    @Override
    public JqlClauseBuilder addNumberCondition(String clauseName, Operator operator, Collection<Long> clauseValues) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("clauseValues", clauseValues);
        Assertions.not("clauseValues is empty", clauseValues.isEmpty());
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(clauseValues.toArray(new Long[clauseValues.size()])));
    }

    @Override
    public JqlClauseBuilder addNumberRangeCondition(String clauseName, Long start, Long end) {
        SingleValueOperand startClause = start == null ? null : new SingleValueOperand(start);
        SingleValueOperand endClause = end == null ? null : new SingleValueOperand(end);
        return this.addRangeCondition(clauseName, startClause, endClause);
    }

    @Override
    public ConditionBuilder addCondition(String clauseName) {
        Assertions.notNull("clauseName", clauseName);
        return new DefaultConditionBuilder(clauseName, this);
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Operand operand) {
        return this.addCondition(clauseName, Operator.EQUALS, operand);
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Operand ... operands) {
        return this.addCondition(clauseName, Operator.IN, operands);
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Collection<? extends Operand> operands) {
        return this.addCondition(clauseName, Operator.IN, operands);
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Operand operand) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.notNull("operand", operand);
        return this.addTerminalClause(clauseName, operator, operand);
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Operand ... operands) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("operands", operands);
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(operands));
    }

    @Override
    public JqlClauseBuilder addCondition(String clauseName, Operator operator, Collection<? extends Operand> operands) {
        Assertions.notNull("clauseName", clauseName);
        Assertions.notNull("operator", operator);
        Assertions.containsNoNulls("operands", operands);
        return this.addTerminalClause(clauseName, operator, new MultiValueOperand(operands));
    }

    @Override
    public JqlClauseBuilder addRangeCondition(String clauseName, Operand start, Operand end) {
        Clause clause;
        Assertions.not("start and end are both null.", start == null && end == null);
        Assertions.notNull("clauseName", clauseName);
        if (start != null) {
            if (end != null) {
                TerminalClauseImpl startClause = new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, start);
                TerminalClauseImpl endClause = new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, end);
                clause = new AndClause(startClause, endClause);
            } else {
                clause = new TerminalClauseImpl(clauseName, Operator.GREATER_THAN_EQUALS, start);
            }
        } else {
            clause = new TerminalClauseImpl(clauseName, Operator.LESS_THAN_EQUALS, end);
        }
        return this.addClause(clause);
    }

    @Override
    public Clause buildClause() {
        return this.builder.build();
    }

    private JqlClauseBuilder addTerminalClause(String clauseName, Operator operator, Operand clauseValue) {
        this.builder = this.builder.clause(new TerminalClauseImpl(clauseName, operator, clauseValue));
        return this;
    }

    @Override
    public JqlClauseBuilder addEmptyCondition(String clauseName) {
        Assertions.notNull("clauseName", clauseName);
        return this.addTerminalClause(clauseName, Operator.IS, EmptyOperand.EMPTY);
    }
}

