/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.builder;

import com.atlassian.jira.jql.builder.ConditionBuilder;
import com.atlassian.jira.jql.builder.DefaultValueBuilder;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.ValueBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Date;

class DefaultConditionBuilder
implements ConditionBuilder {
    private final JqlClauseBuilder builder;
    private final String clauseName;

    DefaultConditionBuilder(String clauseName, JqlClauseBuilder builder) {
        this.builder = Assertions.notNull("builder", builder);
        this.clauseName = Assertions.notNull("clauseName", clauseName);
    }

    @Override
    public ValueBuilder eq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.EQUALS);
    }

    @Override
    public JqlClauseBuilder eq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.EQUALS, value);
    }

    @Override
    public JqlClauseBuilder eq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.EQUALS, value);
    }

    @Override
    public JqlClauseBuilder eq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.EQUALS, date);
    }

    @Override
    public JqlClauseBuilder eq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.EQUALS, operand);
    }

    @Override
    public JqlClauseBuilder eqEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.EQUALS, (Operand)EmptyOperand.EMPTY);
    }

    @Override
    public JqlClauseBuilder eqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName);
    }

    @Override
    public JqlClauseBuilder eqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName, args);
    }

    @Override
    public JqlClauseBuilder eqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.EQUALS, funcName, args);
    }

    @Override
    public ValueBuilder notEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_EQUALS);
    }

    @Override
    public JqlClauseBuilder notEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder notEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder notEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_EQUALS, operand);
    }

    @Override
    public JqlClauseBuilder notEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_EQUALS, date);
    }

    @Override
    public JqlClauseBuilder notEqEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.NOT_EQUALS, (Operand)EmptyOperand.EMPTY);
    }

    @Override
    public JqlClauseBuilder notEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName);
    }

    @Override
    public JqlClauseBuilder notEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName, args);
    }

    @Override
    public JqlClauseBuilder notEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_EQUALS, funcName, args);
    }

    @Override
    public ValueBuilder like() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LIKE);
    }

    @Override
    public JqlClauseBuilder like(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LIKE, value);
    }

    @Override
    public JqlClauseBuilder like(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LIKE, value);
    }

    @Override
    public JqlClauseBuilder like(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LIKE, operand);
    }

    @Override
    public JqlClauseBuilder like(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LIKE, date);
    }

    @Override
    public JqlClauseBuilder likeFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName);
    }

    @Override
    public JqlClauseBuilder likeFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName, args);
    }

    @Override
    public JqlClauseBuilder likeFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LIKE, funcName, args);
    }

    @Override
    public ValueBuilder notLike() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_LIKE);
    }

    @Override
    public JqlClauseBuilder notLike(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_LIKE, value);
    }

    @Override
    public JqlClauseBuilder notLike(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_LIKE, value);
    }

    @Override
    public JqlClauseBuilder notLike(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_LIKE, operand);
    }

    @Override
    public JqlClauseBuilder notLike(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_LIKE, date);
    }

    @Override
    public JqlClauseBuilder notLikeFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName);
    }

    @Override
    public JqlClauseBuilder notLikeFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName, args);
    }

    @Override
    public JqlClauseBuilder notLikeFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_LIKE, funcName, args);
    }

    @Override
    public ValueBuilder is() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IS);
    }

    @Override
    public JqlClauseBuilder isEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.IS, (Operand)EmptyOperand.EMPTY);
    }

    @Override
    public ValueBuilder isNot() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IS_NOT);
    }

    @Override
    public JqlClauseBuilder isNotEmpty() {
        return this.builder.addCondition(this.clauseName, Operator.IS_NOT, (Operand)EmptyOperand.EMPTY);
    }

    @Override
    public ValueBuilder lt() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LESS_THAN);
    }

    @Override
    public JqlClauseBuilder lt(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LESS_THAN, value);
    }

    @Override
    public JqlClauseBuilder lt(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LESS_THAN, value);
    }

    @Override
    public JqlClauseBuilder lt(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LESS_THAN, operand);
    }

    @Override
    public JqlClauseBuilder lt(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LESS_THAN, date);
    }

    @Override
    public JqlClauseBuilder ltFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName);
    }

    @Override
    public JqlClauseBuilder ltFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName, args);
    }

    @Override
    public JqlClauseBuilder ltFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN, funcName, args);
    }

    @Override
    public ValueBuilder ltEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.LESS_THAN_EQUALS);
    }

    @Override
    public JqlClauseBuilder ltEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.LESS_THAN_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder ltEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.LESS_THAN_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder ltEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.LESS_THAN_EQUALS, operand);
    }

    @Override
    public JqlClauseBuilder ltEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.LESS_THAN_EQUALS, date);
    }

    @Override
    public JqlClauseBuilder ltEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName);
    }

    @Override
    public JqlClauseBuilder ltEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName, args);
    }

    @Override
    public JqlClauseBuilder ltEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.LESS_THAN_EQUALS, funcName, args);
    }

    @Override
    public ValueBuilder gt() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.GREATER_THAN);
    }

    @Override
    public JqlClauseBuilder gt(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.GREATER_THAN, value);
    }

    @Override
    public JqlClauseBuilder gt(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.GREATER_THAN, value);
    }

    @Override
    public JqlClauseBuilder gt(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.GREATER_THAN, operand);
    }

    @Override
    public JqlClauseBuilder gt(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.GREATER_THAN, date);
    }

    @Override
    public JqlClauseBuilder gtFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName);
    }

    @Override
    public JqlClauseBuilder gtFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName, args);
    }

    @Override
    public JqlClauseBuilder gtFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN, funcName, args);
    }

    @Override
    public ValueBuilder gtEq() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.GREATER_THAN_EQUALS);
    }

    @Override
    public JqlClauseBuilder gtEq(String value) {
        return this.builder.addStringCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder gtEq(Long value) {
        return this.builder.addNumberCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, value);
    }

    @Override
    public JqlClauseBuilder gtEq(Operand operand) {
        return this.builder.addCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, operand);
    }

    @Override
    public JqlClauseBuilder gtEq(Date date) {
        return this.builder.addDateCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, date);
    }

    @Override
    public JqlClauseBuilder gtEqFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName);
    }

    @Override
    public JqlClauseBuilder gtEqFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName, args);
    }

    @Override
    public JqlClauseBuilder gtEqFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.GREATER_THAN_EQUALS, funcName, args);
    }

    @Override
    public ValueBuilder in() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.IN);
    }

    @Override
    public JqlClauseBuilder in(String ... values) {
        return this.builder.addStringCondition(this.clauseName, Operator.IN, values);
    }

    @Override
    public JqlClauseBuilder inStrings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, Operator.IN, values);
    }

    @Override
    public JqlClauseBuilder in(Long ... values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.IN, values);
    }

    @Override
    public JqlClauseBuilder inNumbers(Collection<Long> values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.IN, values);
    }

    @Override
    public JqlClauseBuilder in(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, Operator.IN, operands);
    }

    @Override
    public JqlClauseBuilder inOperands(Collection<Operand> operands) {
        return this.builder.addCondition(this.clauseName, Operator.IN, operands);
    }

    @Override
    public JqlClauseBuilder in(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.IN, dates);
    }

    @Override
    public JqlClauseBuilder inDates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.IN, dates);
    }

    @Override
    public JqlClauseBuilder inFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName);
    }

    @Override
    public JqlClauseBuilder inFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName, args);
    }

    @Override
    public JqlClauseBuilder inFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.IN, funcName, args);
    }

    @Override
    public ValueBuilder notIn() {
        return new DefaultValueBuilder(this.builder, this.clauseName, Operator.NOT_IN);
    }

    @Override
    public JqlClauseBuilder notIn(String ... values) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_IN, values);
    }

    @Override
    public JqlClauseBuilder notInStrings(Collection<String> values) {
        return this.builder.addStringCondition(this.clauseName, Operator.NOT_IN, values);
    }

    @Override
    public JqlClauseBuilder notIn(Long ... values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_IN, values);
    }

    @Override
    public JqlClauseBuilder notInNumbers(Collection<Long> values) {
        return this.builder.addNumberCondition(this.clauseName, Operator.NOT_IN, values);
    }

    @Override
    public JqlClauseBuilder notIn(Operand ... operands) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_IN, operands);
    }

    @Override
    public JqlClauseBuilder notIn(Date ... dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_IN, dates);
    }

    @Override
    public JqlClauseBuilder notInDates(Collection<Date> dates) {
        return this.builder.addDateCondition(this.clauseName, Operator.NOT_IN, dates);
    }

    @Override
    public JqlClauseBuilder notInOperands(Collection<Operand> operands) {
        return this.builder.addCondition(this.clauseName, Operator.NOT_IN, operands);
    }

    @Override
    public JqlClauseBuilder notInFunc(String funcName) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName);
    }

    @Override
    public JqlClauseBuilder notInFunc(String funcName, String ... args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName, args);
    }

    @Override
    public JqlClauseBuilder notInFunc(String funcName, Collection<String> args) {
        return this.builder.addFunctionCondition(this.clauseName, Operator.NOT_IN, funcName, args);
    }

    @Override
    public JqlClauseBuilder range(Date start, Date end) {
        return this.builder.addDateRangeCondition(this.clauseName, start, end);
    }

    @Override
    public JqlClauseBuilder range(String start, String end) {
        return this.builder.addStringRangeCondition(this.clauseName, start, end);
    }

    @Override
    public JqlClauseBuilder range(Long start, Long end) {
        return this.builder.addNumberRangeCondition(this.clauseName, start, end);
    }

    @Override
    public JqlClauseBuilder range(Operand start, Operand end) {
        return this.builder.addRangeCondition(this.clauseName, start, end);
    }
}

