/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.projectroles;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.jelly.tag.projectroles.ProjectRoleTagSupport;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;

public class RemoveActorsFromProjectRole
extends ProjectRoleTagSupport {
    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectRoleService projectRoleService = ComponentManager.getComponentInstanceOfType(ProjectRoleService.class);
        Project project = this.getProject();
        String actorType = (String)this.getProperties().get("actortype");
        boolean actorsProvided = this.actorsProvided();
        if (project == null && actorsProvided) {
            Collection actors = this.getActors();
            for (String actorName : actors) {
                projectRoleService.removeAllRoleActorsByNameAndType(this.getUser(), actorName, actorType, errorCollection);
            }
        } else if (project != null && actorsProvided) {
            ProjectRole projectRole = this.getProjectRole(errorCollection);
            projectRoleService.removeActorsFromProjectRole(this.getUser(), this.getActors(), projectRole, project, actorType, errorCollection);
        } else {
            projectRoleService.removeAllRoleActorsByProject(this.getUser(), project, errorCollection);
        }
        if (errorCollection.hasAnyErrors()) {
            throw new JellyTagException(errorCollection.toString());
        }
        this.invokeBody(xmlOutput);
    }

    private boolean actorsProvided() {
        Collection actors = this.getActors();
        return actors != null && !actors.isEmpty();
    }
}

