/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project.enterprise;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.action.component.SelectComponentAssigneesUtil;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.tag.JellyUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.ErrorCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class SelectComponentAssignees
extends JiraDynaBeanTagSupport {
    private static final transient Logger log = Logger.getLogger(SelectComponentAssignees.class);
    private static final String PROJECT_KEY = "project-key";
    private static final String COMPONENT_NAME = "componentName";
    private static final String ASSIGNEE_TYPE = "assigneeType";
    private static final String PROJECT_DEFAULT = "projectDefault";
    private static final String COMPONENT_LEAD = "componentLead";
    private static final String PROJECT_LEAD = "projectLead";
    private static final String UNASSIGNED = "unassigned";
    private final SelectComponentAssigneesUtil selectComponentAssigneesUtil;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectManager projectManager;

    public SelectComponentAssignees(JiraAuthenticationContext authenticationContext, ProjectManager projectManager) {
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.selectComponentAssigneesUtil = ComponentManager.getComponentInstanceOfType(SelectComponentAssigneesUtil.class);
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        this.validateAttributes();
        try {
            Map updateComponentAssigneeTypes = this.getUpdateComponentAssigneeTypes();
            this.selectComponentAssigneesUtil.setComponentAssigneeTypes(updateComponentAssigneeTypes);
            ErrorCollection errors = this.selectComponentAssigneesUtil.execute(this.authenticationContext.getLoggedInUser());
            if (errors != null && errors.hasAnyErrors()) {
                JellyUtils.processErrorCollection(errors);
            }
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error while running tag", (Throwable)e);
        }
    }

    private void validateAttributes() throws JellyTagException {
        if (!this.paramSpecified(PROJECT_KEY) || StringUtils.isEmpty((String)this.getProjectKey())) {
            throw new MissingAttributeException(PROJECT_KEY);
        }
        if (!this.paramSpecified(COMPONENT_NAME) || StringUtils.isEmpty((String)this.getComponentName())) {
            throw new MissingAttributeException(COMPONENT_NAME);
        }
        if (!this.paramSpecified(ASSIGNEE_TYPE) || this.getAssigneeType() == null) {
            throw new MissingAttributeException(ASSIGNEE_TYPE);
        }
        Project project = this.projectManager.getProjectObjByKey(this.getProjectKey());
        if (this.selectComponentAssigneesUtil.hasPermission(project, this.authenticationContext.getLoggedInUser())) {
            this.selectComponentAssigneesUtil.setComponentAssigneeTypes(this.getUpdateComponentAssigneeTypes());
            this.selectComponentAssigneesUtil.setFieldPrefix("component_");
            ErrorCollection errors = this.selectComponentAssigneesUtil.validate();
            if (errors != null && errors.hasAnyErrors()) {
                JellyUtils.processErrorCollection(errors);
            }
        } else {
            throw new JellyTagException("User " + this.authenticationContext.getLoggedInUser() + " does not have " + Permissions.getShortName(0) + " permission to select component assignee.");
        }
    }

    private boolean paramSpecified(String paramName) {
        return this.getProperties().containsKey(paramName);
    }

    private String getProjectKey() {
        return (String)this.getProperties().get(PROJECT_KEY);
    }

    private String getComponentName() {
        return (String)this.getProperties().get(COMPONENT_NAME);
    }

    private Long getAssigneeType() throws JellyTagException {
        String assigneeType = (String)this.getProperties().get(ASSIGNEE_TYPE);
        if (PROJECT_DEFAULT.equals(assigneeType)) {
            return 0L;
        }
        if (COMPONENT_LEAD.equals(assigneeType)) {
            return 1L;
        }
        if (PROJECT_LEAD.equals(assigneeType)) {
            return 2L;
        }
        if (UNASSIGNED.equals(assigneeType)) {
            return 3L;
        }
        throw new JellyTagException("Invalid assigneetype value: " + assigneeType);
    }

    private Map getUpdateComponentAssigneeTypes() throws JellyTagException {
        HashMap<GenericValue, Object> componentAssigneeTypes = new HashMap<GenericValue, Object>();
        GenericValue project = this.projectManager.getProjectByKey(this.getProjectKey());
        for (GenericValue componentGv : this.projectManager.getComponents(project)) {
            if (componentGv.get("name").equals(this.getComponentName())) {
                componentAssigneeTypes.put(componentGv, this.getAssigneeType());
                continue;
            }
            componentAssigneeTypes.put(componentGv, componentGv.get("assigneetype"));
        }
        return componentAssigneeTypes;
    }
}

