/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin.enterprise;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.tag.enterprise.IssueSchemeAwareActionTagSupport;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class AddIssueSecurityLevel
extends IssueSchemeAwareActionTagSupport {
    private static final Logger log = Logger.getLogger(AddIssueSecurityLevel.class);
    private static final String ISSUE_SECURITY_LEVEL_NAME = "name";
    private static final String ISSUE_SECURITY_LEVEL_DESCRIPTION = "description";
    private boolean hasPreviousIssueSecurityLevel = false;
    private Long previousIssueSecurityLevelId = null;

    public AddIssueSecurityLevel() {
        this.setActionName("EditIssueSecurities!addLevel");
        this.ignoreErrors = false;
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        if (this.hasIssueScheme()) {
            this.setProperty("schemeId", this.getIssueSchemeId().toString());
        }
    }

    @Override
    protected void postTagExecution(XMLOutput output) {
        log.debug((Object)"CreatePermissionScheme.postTagExecution");
        this.copyRedirectUrlParametersToTag(this.getResponse().getRedirectUrl());
        List<GenericValue> levels = ManagerFactory.getIssueSecurityLevelManager().getSchemeIssueSecurityLevels(this.getIssueSchemeId());
        for (int i = 0; i < levels.size(); ++i) {
            GenericValue genericValue = levels.get(i);
            if (!this.getProperty(ISSUE_SECURITY_LEVEL_NAME).equals(genericValue.getString(ISSUE_SECURITY_LEVEL_NAME))) continue;
            this.setPreviousIssueSecurityLevelId((Long)this.getContext().getVariable("jelly.issue.scheme.level.id"));
            this.getContext().setVariable("jelly.issue.scheme.level.id", (Object)genericValue.getLong("id"));
            return;
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        if (this.hasPreviousIssueSecurityLevel) {
            this.getContext().setVariable("jelly.issue.scheme.level.id", (Object)this.getPreviousIssueSecurityLevelId());
        }
    }

    @Override
    public String[] getRequiredProperties() {
        return new String[]{ISSUE_SECURITY_LEVEL_NAME, ISSUE_SECURITY_LEVEL_DESCRIPTION};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[]{"jelly.issue.scheme.level.id"};
    }

    public Long getPreviousIssueSecurityLevelId() {
        return this.previousIssueSecurityLevelId;
    }

    public void setPreviousIssueSecurityLevelId(Long previousIssueSecurityLevelId) {
        this.hasPreviousIssueSecurityLevel = true;
        this.previousIssueSecurityLevelId = previousIssueSecurityLevelId;
    }
}

