/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.ProjectContext;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.jelly.tag.JellyUtils;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import java.util.List;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class CreateCustomField
extends TagSupport {
    private String customFieldIdVar;
    private String fieldType;
    private String fieldScope;
    private String fieldName;
    private String description;
    private String searcher;
    private String issueTypeId;
    private String issueType;
    private String projectKey;
    private Long project;
    private static final Logger log = Logger.getLogger(CreateCustomField.class);
    public static final String FIELD_TYPE_PREFIX = "com.atlassian.jira.plugin.system.customfieldtypes:";
    private CustomField createdCustomField = null;
    private final OptionsManager optionsManager;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldValidator customFieldValidator;
    private final ProjectManager projectManager;
    private final ConstantsManager constantsManager;
    private final JiraContextTreeManager treeManager;
    private long numberAdded = 0L;

    public CreateCustomField(OptionsManager optionsManager, CustomFieldManager customFieldManager, CustomFieldValidator customFieldValidator, ProjectManager projectManager, ConstantsManager constantsManager, JiraContextTreeManager treeManager) {
        this.optionsManager = optionsManager;
        this.customFieldManager = customFieldManager;
        this.customFieldValidator = customFieldValidator;
        this.projectManager = projectManager;
        this.constantsManager = constantsManager;
        this.treeManager = treeManager;
    }

    public void doTag(XMLOutput xmlOutput) throws MissingAttributeException, JellyTagException {
        this.validate();
        CustomFieldSearcher cfs = ObjectUtils.isValueSelected(this.searcher) ? this.customFieldManager.getCustomFieldSearcher(this.getSearcher()) : null;
        try {
            Script body;
            CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(this.getFieldType());
            this.createdCustomField = "issuetype".equals(this.getFieldScope()) ? this.customFieldManager.createCustomField(this.getFieldName(), this.getDescription(), customFieldType, cfs, EasyList.build((Object)GlobalIssueContext.getInstance()), EasyList.build((Object)this.getIssueTypeGv())) : ("project".equals(this.getFieldScope()) ? this.customFieldManager.createCustomField(this.getFieldName(), this.getDescription(), customFieldType, cfs, EasyList.build((Object)new ProjectContext(this.getProjectGv(), this.treeManager)), EasyList.buildNull()) : this.customFieldManager.createCustomField(this.getFieldName(), this.getDescription(), customFieldType, cfs, EasyList.build((Object)GlobalIssueContext.getInstance()), EasyList.buildNull()));
            if (StringUtils.isNotEmpty((String)this.getCustomFieldIdVar())) {
                this.getContext().setVariable(this.getCustomFieldIdVar(), (Object)this.createdCustomField);
            }
            if ((body = this.getBody()) != null) {
                body.run(this.getContext(), xmlOutput);
            }
        }
        catch (GenericEntityException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    private void validate() throws JellyTagException {
        ErrorCollection errorCollection = this.customFieldValidator.validateType(this.getFieldType());
        ErrorCollection errors = this.customFieldValidator.validateDetails(this.getFieldName(), this.getFieldType(), this.getSearcher());
        errorCollection.addErrorCollection(errors);
        JellyUtils.processErrorCollection(errorCollection);
    }

    public Option addSelectValue(String value) {
        FieldConfigScheme sc;
        MultiMap configs;
        List<FieldConfigScheme> schemes;
        Option newOption = null;
        if (this.createdCustomField != null && (schemes = this.createdCustomField.getConfigurationSchemes()) != null && !schemes.isEmpty() && (configs = (sc = schemes.get(0)).getConfigsByConfig()) != null && !configs.isEmpty()) {
            FieldConfig config = (FieldConfig)configs.keySet().iterator().next();
            newOption = this.optionsManager.createOption(config, null, new Long(this.numberAdded), value);
            ++this.numberAdded;
        }
        return newOption;
    }

    public String getFieldType() {
        if (this.fieldType != null && this.fieldType.indexOf(58) > -1) {
            return this.fieldType;
        }
        return FIELD_TYPE_PREFIX + this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldScope() {
        return this.fieldScope;
    }

    public void setFieldScope(String fieldScope) {
        this.fieldScope = fieldScope;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSearcher() {
        if (this.searcher != null && this.searcher.indexOf(58) > -1) {
            return this.searcher;
        }
        return FIELD_TYPE_PREFIX + this.searcher;
    }

    public void setSearcher(String searcher) {
        this.searcher = searcher;
    }

    public String getIssueTypeId() {
        if (this.issueTypeId == null && this.getIssueType() != null) {
            List<GenericValue> issueTypes = this.constantsManager.getAllIssueTypes();
            for (GenericValue issueType : issueTypes) {
                if (!this.getIssueType().equals(issueType.getString("name"))) continue;
                this.issueTypeId = issueType.getString("id");
            }
        }
        return this.issueTypeId;
    }

    public Long getIssueTypeIdAsLong() {
        try {
            long issueTypeId = Long.parseLong(this.getIssueTypeId());
            return new Long(issueTypeId);
        }
        catch (RuntimeException e) {
            log.warn((Object)e);
            return null;
        }
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getProject() {
        GenericValue projectGv;
        if (this.project == null && this.getProjectKey() != null && (projectGv = this.projectManager.getProjectByKey(this.getProjectKey())) != null) {
            this.project = projectGv.getLong("id");
        }
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getCustomFieldIdVar() {
        return this.customFieldIdVar;
    }

    public void setCustomFieldIdVar(String customFieldIdVar) {
        this.customFieldIdVar = customFieldIdVar;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    private GenericValue getProjectGv() {
        return this.projectManager.getProject(this.getProject());
    }

    private GenericValue getIssueTypeGv() {
        return this.constantsManager.getIssueType(this.getIssueTypeId());
    }
}

