/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.admin;

import com.atlassian.jira.jelly.PermissionSchemeContextAccessor;
import com.atlassian.jira.jelly.PermissionSchemeContextAccessorImpl;
import com.atlassian.jira.jelly.tag.PermissionSchemeAwareActionTagSupport;
import com.atlassian.jira.security.Permissions;
import java.util.List;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.util.StringUtil;

public class AddPermission
extends PermissionSchemeAwareActionTagSupport
implements PermissionSchemeContextAccessor {
    private static final transient Logger log = Logger.getLogger(AddPermission.class);
    private static final String KEY_SCHEME_ID = "schemeId";
    private static final String KEY_PERMISSION_TYPE = "permissions";
    private static final String KEY_GROUP_NAME = "group";
    private static final String KEY_ROLE_NAME = "projectrole";
    private static final String KEY_ROLE_ID = "projectroleid";
    private static final String KEY_TYPE = "type";
    private PermissionSchemeContextAccessor permissionSchemeContextAccessor = new PermissionSchemeContextAccessorImpl((Tag)this);

    public AddPermission() {
        this.setActionName("AddPermission");
        this.ignoreErrors = true;
    }

    @Override
    protected void preContextValidation() {
        super.preContextValidation();
        if (this.getProperties().containsKey(KEY_SCHEME_ID)) {
            this.setPermissionScheme(new Long(this.getProperty(KEY_SCHEME_ID)));
        }
    }

    @Override
    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        this.setProperty(KEY_SCHEME_ID, this.getPermissionSchemeId().toString());
        List permissionsStrings = StringUtil.split((String)this.getProperty(KEY_PERMISSION_TYPE), (String)",");
        String[] permissionsIds = new String[permissionsStrings.size()];
        for (int i = 0; i < permissionsStrings.size(); ++i) {
            permissionsIds[i] = Integer.toString(Permissions.getType((String)permissionsStrings.get(i)));
        }
        this.setProperty(KEY_PERMISSION_TYPE, permissionsIds);
        if (!this.getProperties().containsKey(KEY_TYPE)) {
            this.setProperty(KEY_TYPE, KEY_GROUP_NAME);
        }
        if (!this.getProperties().containsKey(KEY_GROUP_NAME)) {
            this.setProperty(KEY_GROUP_NAME, "");
        }
        if (this.getProperties().containsKey(KEY_ROLE_ID)) {
            this.setProperty(KEY_ROLE_NAME, this.getProperty(KEY_ROLE_ID));
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousPermissionScheme();
    }

    @Override
    public String[] getRequiredProperties() {
        if (KEY_GROUP_NAME.equals(this.getProperty(KEY_TYPE))) {
            return new String[]{KEY_SCHEME_ID, KEY_PERMISSION_TYPE, KEY_TYPE, KEY_GROUP_NAME};
        }
        if (KEY_ROLE_NAME.equals(this.getProperty(KEY_TYPE))) {
            return new String[]{KEY_SCHEME_ID, KEY_PERMISSION_TYPE, KEY_TYPE, KEY_ROLE_ID};
        }
        return new String[]{KEY_SCHEME_ID, KEY_PERMISSION_TYPE, KEY_TYPE};
    }

    @Override
    public String[] getRequiredContextVariablesAfter() {
        return new String[0];
    }

    @Override
    public void setPermissionScheme(Long schemeId) {
        this.permissionSchemeContextAccessor.setPermissionScheme(schemeId);
    }

    @Override
    public void loadPreviousPermissionScheme() {
        this.permissionSchemeContextAccessor.loadPreviousPermissionScheme();
    }
}

