/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.IssueAware;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.ProjectAwareActionTagSupport;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public abstract class IssueAwareActionTagSupport
extends ProjectAwareActionTagSupport
implements IssueAware,
ProjectContextAccessor {
    private static final Logger log = Logger.getLogger(IssueAwareActionTagSupport.class);
    private final ProjectContextAccessor projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);
    private final String[] requiredContextVariables;

    public IssueAwareActionTagSupport() {
        String[] temp = new String[super.getRequiredContextVariables().length + 1];
        System.arraycopy(super.getRequiredContextVariables(), 0, temp, 0, super.getRequiredContextVariables().length);
        temp[temp.length - 1] = "jelly.issue.id";
        this.requiredContextVariables = temp;
    }

    @Override
    protected void preContextValidation() {
        if (!this.hasProject() && this.hasIssue()) {
            this.setProject(this.getIssue().getLong("project"));
        }
    }

    @Override
    protected void endTagExecution(XMLOutput output) {
        this.loadPreviousProject();
    }

    @Override
    public String[] getRequiredContextVariables() {
        return this.requiredContextVariables;
    }

    @Override
    public boolean hasIssue() {
        return this.getContext().getVariables().containsKey("jelly.issue.id");
    }

    @Override
    public Long getIssueId() {
        if (this.hasIssue()) {
            return (Long)this.getContext().getVariable("jelly.issue.id");
        }
        return null;
    }

    @Override
    public GenericValue getIssue() {
        return ComponentAccessor.getIssueManager().getIssue(this.getIssueId());
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }
}

