/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.jelly.NewUserAware;
import com.atlassian.jira.jelly.NewUserContextAccessor;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;

public class NewUserContextAccessorImpl
implements NewUserContextAccessor,
NewUserAware {
    private final Tag tag;
    private boolean hasNewUsername = false;
    private String newUsername = null;

    public NewUserContextAccessorImpl(Tag tag) {
        this.tag = tag;
    }

    @Override
    public JellyContext getContext() {
        return this.tag.getContext();
    }

    @Override
    public void setNewUser(String username) {
        this.setPreviousNewUsername();
        this.resetNewUserContext();
        this.setNewUserContext(username);
    }

    @Override
    public void setNewUser(User user) {
        this.setPreviousNewUsername();
        this.resetNewUserContext();
        this.setNewUserContext(user);
    }

    @Override
    public void loadPreviousNewUser() {
        if (this.hasNewUsername) {
            this.resetNewUserContext();
            this.setNewUser(this.newUsername);
            this.hasNewUsername = false;
            this.newUsername = null;
        }
    }

    private void setPreviousNewUsername() {
        if (this.hasNewUsername()) {
            this.hasNewUsername = true;
            this.newUsername = this.getNewUsername();
        }
    }

    private void resetNewUserContext() {
        this.getContext().removeVariable("jelly.new.username");
    }

    private void setNewUserContext(String username) {
        User user = ManagerFactory.getUserManager().getUser(username);
        this.setNewUserContext(user);
    }

    private void setNewUserContext(User user) {
        this.getContext().setVariable("jelly.new.username", (Object)user.getName());
    }

    @Override
    public boolean hasNewUsername() {
        return this.getContext().getVariables().containsKey("jelly.new.username");
    }

    @Override
    public String getNewUsername() {
        if (this.hasNewUsername()) {
            return (String)this.getContext().getVariable("jelly.new.username");
        }
        return null;
    }
}

