/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.vote;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.DocumentHitCollector;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.vote.VotedIssuesAccessor;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import org.apache.lucene.document.Document;

public class DefaultVotedIssuesAccessor
implements VotedIssuesAccessor {
    private final VoteManager voteManager;
    private final SearchProvider searchProvider;
    private final SearchProviderFactory factory;

    public DefaultVotedIssuesAccessor(@NotNull VoteManager voteManager, @NotNull SearchProvider searchProvider, @NotNull SearchProviderFactory factory) {
        this.voteManager = Assertions.notNull("voteManager", voteManager);
        this.searchProvider = Assertions.notNull("searchProvider", searchProvider);
        this.factory = Assertions.notNull("factory", factory);
    }

    @Override
    public Iterable<Long> getVotedIssueIds(User voter, User searcher, VotedIssuesAccessor.Security security) {
        IssueIdCollector collector = new IssueIdCollector();
        Query query = DefaultVotedIssuesAccessor.getVoterQuery(voter);
        try {
            switch (security) {
                case OVERRIDE: {
                    this.searchProvider.searchOverrideSecurity(query, searcher, collector);
                    break;
                }
                case RESPECT: {
                    this.searchProvider.search(query, searcher, collector);
                }
            }
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return collector.getIds();
    }

    @Override
    public boolean isVotingEnabled() {
        return this.voteManager.isVotingEnabled();
    }

    static Query getVoterQuery(User voter) {
        return JqlQueryBuilder.newBuilder().where().voterUser(voter.getName()).endWhere().buildQuery();
    }

    private class IssueIdCollector
    extends DocumentHitCollector {
        private final CollectionBuilder<String> issueIds;

        public IssueIdCollector() {
            super(DefaultVotedIssuesAccessor.this.factory.getSearcher("issues"));
            this.issueIds = CollectionBuilder.newBuilder();
        }

        @Override
        public void collect(Document d) {
            this.issueIds.add(d.get("issue_id"));
        }

        Iterable<Long> getIds() {
            return Transformed.list(this.issueIds.asList(), new Function<String, Long>(){

                @Override
                public Long get(String input) {
                    return Long.valueOf(input);
                }
            });
        }
    }
}

