/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.mail.SubscriptionMailQueueMockRequest;
import com.atlassian.jira.plugin.issueview.IssueView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.plugin.PluginAccessor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SearchRequestViewUtils {
    private static final BuildUtilsInfo BUILD_UTILS_INFO = new BuildUtilsInfoImpl();

    public static String getLink(SearchRequest searchRequest, String baseUrl, User user) {
        StringBuffer link = new StringBuffer(baseUrl).append("/secure/IssueNavigator.jspa?");
        if (searchRequest.getId() != null) {
            link.append("requestId=").append(searchRequest.getId());
        } else {
            link.append("reset=true").append(SearchRequestViewUtils.getSearchService().getQueryString(user, searchRequest.getQuery()));
        }
        return link.toString();
    }

    private static SearchService getSearchService() {
        return ComponentManager.getInstance().getSearchService();
    }

    public static <V extends IssueView> V getIssueView(Class<V> issueViewClass) {
        PluginAccessor pluginAccessor = ComponentManager.getComponentInstanceOfType(PluginAccessor.class);
        List modules = pluginAccessor.getEnabledModulesByClass(issueViewClass);
        if (!modules.isEmpty()) {
            return (V)((IssueView)modules.get(0));
        }
        return null;
    }

    public static <V extends SearchRequestView> V getSearchRequestView(Class<V> searchRequestViewClass) {
        PluginAccessor pluginAccessor = ComponentManager.getComponentInstanceOfType(PluginAccessor.class);
        List modules = pluginAccessor.getEnabledModulesByClass(searchRequestViewClass);
        if (!modules.isEmpty()) {
            return (V)((SearchRequestView)modules.get(0));
        }
        return null;
    }

    public static String getTitle(SearchRequest searchRequest, String jiraTitle) {
        return searchRequest.getName() != null ? searchRequest.getName() + " (" + jiraTitle + ")" : jiraTitle;
    }

    public static String getGeneratedInfo(User user) {
        I18nBean i18nBean = new I18nBean(user);
        if (user != null) {
            return i18nBean.getText("rss.search.request.view.header.text.with.user", new Date().toString(), user.getDisplayName(), BUILD_UTILS_INFO.getBuildInformation());
        }
        return i18nBean.getText("rss.search.request.view.header.text.with.out.user", new Date().toString(), BUILD_UTILS_INFO.getBuildInformation());
    }

    public static HttpServletRequest getMockRequest(String baseUrl) {
        return new SubscriptionMailQueueMockRequest(SearchRequestViewUtils.getContextPath(baseUrl));
    }

    private static String getContextPath(String baseURL) {
        try {
            return new URL(baseURL).getPath();
        }
        catch (MalformedURLException e) {
            return "Incorrect baseURL format: " + baseURL;
        }
    }
}

