/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IssueObjectIssuesIterable
implements IssuesIterable {
    private final Collection<Issue> issueObjects;

    public IssueObjectIssuesIterable(Collection<? extends Issue> issueObjects) {
        this.issueObjects = Collections.unmodifiableCollection(new ArrayList<Issue>(issueObjects));
    }

    protected Issue transform(Object o) {
        return (Issue)o;
    }

    @Override
    public final void foreach(Consumer<Issue> sink) {
        CollectionUtil.foreach(this.issueObjects, sink);
    }

    @Override
    public int size() {
        return this.issueObjects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.issueObjects.isEmpty();
    }

    @Override
    public String toString() {
        List<String> issueKeys = CollectionUtil.transform(this.issueObjects, new Function<Issue, String>(){

            @Override
            public String get(Issue object) {
                return object.getKey();
            }
        });
        return this.getClass().getName() + " (" + this.size() + " items): " + issueKeys;
    }
}

