/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.Collection;

public class IssueImplAggregateTimeTrackingCalculator
implements AggregateTimeTrackingCalculator {
    private final PermissionChecker permissionChecker;

    public IssueImplAggregateTimeTrackingCalculator(final JiraAuthenticationContext context, final PermissionManager permissionManager) {
        this(new PermissionChecker(){

            @Override
            public boolean hasPermission(Issue subTask) {
                return permissionManager.hasPermission(10, subTask, context.getLoggedInUser());
            }
        });
    }

    public IssueImplAggregateTimeTrackingCalculator(PermissionChecker permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    @Override
    public AggregateTimeTrackingBean getAggregates(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue must not be null");
        }
        AggregateTimeTrackingBean bean = new AggregateTimeTrackingBean(issue.getOriginalEstimate(), issue.getEstimate(), issue.getTimeSpent(), 0);
        if (issue.isSubTask()) {
            return bean;
        }
        Collection<Issue> subTasks = issue.getSubTaskObjects();
        if (subTasks != null && !subTasks.isEmpty()) {
            int subTaskCount = 0;
            for (Issue subTask : subTasks) {
                if (!this.permissionChecker.hasPermission(subTask)) continue;
                bean.setRemainingEstimate(AggregateTimeTrackingBean.addAndPreserveNull(subTask.getEstimate(), bean.getRemainingEstimate()));
                bean.setOriginalEstimate(AggregateTimeTrackingBean.addAndPreserveNull(subTask.getOriginalEstimate(), bean.getOriginalEstimate()));
                bean.setTimeSpent(AggregateTimeTrackingBean.addAndPreserveNull(subTask.getTimeSpent(), bean.getTimeSpent()));
                bean.bumpGreatestSubTaskEstimate(subTask.getOriginalEstimate(), subTask.getEstimate(), subTask.getTimeSpent());
                ++subTaskCount;
            }
            bean.setSubTaskCount(subTaskCount);
        }
        return bean;
    }

    public static interface PermissionChecker {
        public boolean hasPermission(Issue var1);
    }
}

