/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.util.AbstractTransformIssueIterator;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class IssueIdsIssueIterable
implements IssuesIterable {
    private final Collection<Long> ids;
    private final IssueManager issueManager;

    public IssueIdsIssueIterable(Collection<Long> issueIds, IssueManager issueManager) {
        this.ids = Collections.unmodifiableCollection(new ArrayList<Long>(Assertions.notNull("issueIds", issueIds)));
        this.issueManager = Assertions.notNull("issueManager", issueManager);
    }

    @Override
    public void foreach(Consumer<Issue> sink) {
        CollectionUtil.foreach(new AbstractTransformIssueIterator<Long>(this.ids){

            @Override
            protected Issue transform(Long o) {
                return IssueIdsIssueIterable.this.issueManager.getIssueObject(o);
            }
        }, sink);
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ids.isEmpty();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " (" + this.size() + " items): " + this.ids;
    }
}

