/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.util.AbstractTransformIssueIterator;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

public class IssueGVsIssueIterable
implements IssuesIterable {
    private final Collection<GenericValue> issueGVs;
    private final IssueFactory issueFactory;

    public IssueGVsIssueIterable(Collection<GenericValue> issueGVs, IssueFactory issueFactory) {
        this.issueGVs = Collections.unmodifiableCollection(new ArrayList<GenericValue>(issueGVs));
        if (issueFactory == null) {
            throw new NullPointerException(this.getClass().getName() + " needs a not null " + IssueFactory.class.getName() + " instance");
        }
        this.issueFactory = issueFactory;
    }

    @Override
    public final void foreach(Consumer<Issue> sink) {
        CollectionUtil.foreach(new AbstractTransformIssueIterator<GenericValue>(this.issueGVs){

            @Override
            protected Issue transform(GenericValue o) {
                return IssueGVsIssueIterable.this.issueFactory.getIssue(o);
            }
        }, sink);
    }

    @Override
    public int size() {
        return this.issueGVs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.issueGVs.isEmpty();
    }

    @Override
    public String toString() {
        List<String> issueKeys = CollectionUtil.transform(this.issueGVs, new Function<GenericValue, String>(){

            @Override
            public String get(GenericValue object) {
                return object.getString("key");
            }
        });
        return this.getClass().getName() + " (" + this.size() + " items): " + issueKeys;
    }
}

