/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.query.Query;
import java.util.Collections;
import java.util.HashSet;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.search.IndexSearcher;

public class DocumentIssueAggregateTimeTrackingCalculator
implements AggregateTimeTrackingCalculator {
    private final JiraAuthenticationContext context;
    private final SearchProviderFactory searchProviderFactory;
    private final SearchProvider searchProvider;
    private final LuceneFieldSorter remainingEstimateSorter;
    private final LuceneFieldSorter originalEstimateSorter;
    private final LuceneFieldSorter timeSpentSorter;

    public DocumentIssueAggregateTimeTrackingCalculator(JiraAuthenticationContext context, SearchProviderFactory searchProviderFactory, SearchProvider searchProvider, FieldManager fieldManager) {
        this.context = context;
        this.searchProviderFactory = searchProviderFactory;
        this.searchProvider = searchProvider;
        this.originalEstimateSorter = this.getSorter(fieldManager, "timeoriginalestimate");
        this.timeSpentSorter = this.getSorter(fieldManager, "timespent");
        this.remainingEstimateSorter = this.getSorter(fieldManager, "timeestimate");
    }

    LuceneFieldSorter getSorter(FieldManager fieldManager, String field) {
        return fieldManager.getNavigableField(field).getSorter();
    }

    @Override
    public AggregateTimeTrackingBean getAggregates(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue must not be null");
        }
        AggregateTimeTrackingBean aggregateBean = new AggregateTimeTrackingBean(issue.getOriginalEstimate(), issue.getEstimate(), issue.getTimeSpent(), 0);
        if (issue.isSubTask()) {
            return aggregateBean;
        }
        Query query = this.getSubTaskClause(issue.getId()).buildQuery();
        IndexSearcher searcher = this.searchProviderFactory.getSearcher("issues");
        AggregateHitCollector collector = new AggregateHitCollector(searcher, aggregateBean, this.remainingEstimateSorter, this.originalEstimateSorter, this.timeSpentSorter);
        try {
            this.searchProvider.search(query, this.getUser(), collector);
            aggregateBean.setSubTaskCount(collector.getInvocationCount());
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return aggregateBean;
    }

    User getUser() {
        return this.context.getLoggedInUser();
    }

    JqlClauseBuilder getSubTaskClause(Long issueId) {
        return JqlQueryBuilder.newBuilder().where().issueParent().eq(issueId);
    }

    static class AggregateHitCollector
    extends FieldableDocumentHitCollector {
        private final AggregateTimeTrackingBean aggregateBean;
        final LuceneFieldSorter originalEstimateSorter;
        final LuceneFieldSorter timeSpentSorter;
        final LuceneFieldSorter remainingEstimateSorter;
        final FieldSelector fieldSelector;
        int invocationCount = 0;

        public AggregateHitCollector(IndexSearcher searchable, AggregateTimeTrackingBean bean, LuceneFieldSorter remainingEstimateSorter, LuceneFieldSorter originalEstimateSorter, LuceneFieldSorter timeSpentSorter) {
            super(searchable);
            this.aggregateBean = bean;
            this.originalEstimateSorter = originalEstimateSorter;
            this.timeSpentSorter = timeSpentSorter;
            this.remainingEstimateSorter = remainingEstimateSorter;
            HashSet<String> fieldsToLoad = new HashSet<String>();
            fieldsToLoad.add(timeSpentSorter.getDocumentConstant());
            fieldsToLoad.add(originalEstimateSorter.getDocumentConstant());
            fieldsToLoad.add(remainingEstimateSorter.getDocumentConstant());
            this.fieldSelector = new SetBasedFieldSelector(fieldsToLoad, Collections.EMPTY_SET);
        }

        @Override
        protected FieldSelector getFieldSelector() {
            return this.fieldSelector;
        }

        @Override
        public void collect(Document d) {
            Long timeSpent = this.getValueFromDocument(d, this.timeSpentSorter);
            Long remainingEstimate = this.getValueFromDocument(d, this.remainingEstimateSorter);
            Long originalEstimate = this.getValueFromDocument(d, this.originalEstimateSorter);
            this.aggregateBean.setTimeSpent(AggregateTimeTrackingBean.addAndPreserveNull(this.aggregateBean.getTimeSpent(), timeSpent));
            this.aggregateBean.setRemainingEstimate(AggregateTimeTrackingBean.addAndPreserveNull(this.aggregateBean.getRemainingEstimate(), remainingEstimate));
            this.aggregateBean.setOriginalEstimate(AggregateTimeTrackingBean.addAndPreserveNull(this.aggregateBean.getOriginalEstimate(), originalEstimate));
            this.aggregateBean.bumpGreatestSubTaskEstimate(originalEstimate, remainingEstimate, originalEstimate);
            ++this.invocationCount;
        }

        Long getValueFromDocument(Document d, LuceneFieldSorter sorter) {
            return (Long)sorter.getValueFromLuceneField(this.getRawDocumentValue(d, sorter.getDocumentConstant()));
        }

        String getRawDocumentValue(Document d, String documentConstant) {
            return d.get(documentConstant);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }
    }
}

