/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final OfBizDelegator ofBizDelegator;
    private final IssueEventManager issueEventManager;

    public DefaultIssueUpdater(OfBizDelegator ofBizDelegator, IssueEventManager issueEventManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.issueEventManager = issueEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) {
        GenericValue changedIssue = iub.getChangedIssue();
        changedIssue.set("updated", (Object)UtilDateTime.nowTimestamp());
        Transaction txn = Txn.begin();
        try {
            this.ofBizDelegator.storeAll((List<GenericValue>)ImmutableList.of((Object)changedIssue));
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(iub.getUser(), iub.getOriginalIssue(), changedIssue, iub.getChangeItems(), generateChangeItems);
            txn.commit();
            if ((changeGroup != null || iub.getComment() != null) && iub.isDispatchEvent()) {
                IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
                this.issueEventManager.dispatchEvent(iub.getEventTypeId(), issueFactory.getIssue(changedIssue), iub.getUser(), iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
            }
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }
}

