/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.util.DatabaseIssuesIterator;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.CollectionUtil;

public class DatabaseIssuesIterable
implements IssuesIterable {
    private final OfBizDelegator delegator;
    private final IssueFactory issueFactory;

    public DatabaseIssuesIterable(OfBizDelegator delegator, IssueFactory issueFactory) {
        if (delegator == null) {
            throw new NullPointerException(this.getClass().getName() + " needs a not null " + OfBizDelegator.class.getName() + " instance");
        }
        if (issueFactory == null) {
            throw new NullPointerException(this.getClass().getName() + " needs a not null " + IssueFactory.class.getName() + " instance");
        }
        this.delegator = delegator;
        this.issueFactory = issueFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foreach(Consumer<Issue> sink) {
        DatabaseIssuesIterator iterator = new DatabaseIssuesIterator(this.delegator, this.issueFactory);
        try {
            CollectionUtil.foreach(iterator, sink);
        }
        finally {
            iterator.close();
        }
    }

    @Override
    public int size() {
        return (int)this.delegator.getCount("Issue");
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": All issues in the database.";
    }
}

