/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.DocumentIssueImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculator;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.util.DocumentIssueAggregateTimeTrackingCalculator;
import com.atlassian.jira.issue.util.IssueImplAggregateTimeTrackingCalculator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;

public class AggregateTimeTrackingCalculatorFactoryImpl
implements AggregateTimeTrackingCalculatorFactory {
    private final JiraAuthenticationContext context;
    private final PermissionManager permissionManager;
    private final SearchProviderFactory searchProviderFactory;
    private SearchProvider searchProvider = null;
    private FieldManager fieldManager = null;

    public AggregateTimeTrackingCalculatorFactoryImpl(JiraAuthenticationContext context, SearchProviderFactory searchProviderFactory, PermissionManager permissionManager) {
        this.context = context;
        this.searchProviderFactory = searchProviderFactory;
        this.permissionManager = permissionManager;
    }

    @Override
    public AggregateTimeTrackingCalculator getCalculator(Issue issue) {
        if (issue instanceof DocumentIssueImpl) {
            return new DocumentIssueAggregateTimeTrackingCalculator(this.context, this.searchProviderFactory, this.getSearchProvider(), this.getFieldManager());
        }
        return new IssueImplAggregateTimeTrackingCalculator(this.context, this.permissionManager);
    }

    private FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = ComponentManager.getInstance().getFieldManager();
        }
        return this.fieldManager;
    }

    public void setFieldManager(FieldManager fieldManager) {
        this.fieldManager = fieldManager;
    }

    private SearchProvider getSearchProvider() {
        if (this.searchProvider == null) {
            this.searchProvider = ComponentManager.getInstance().getSearchProvider();
        }
        return this.searchProvider;
    }

    public void setSearchProvider(SearchProvider searchProvider) {
        this.searchProvider = searchProvider;
    }
}

