/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.transport.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextImpl;
import com.atlassian.jira.issue.transport.impl.ActionParamsImpl;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.util.navigator.IssueNavigatorType;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class IssueNavigatorActionParams
extends ActionParamsImpl {
    private static final String PAGER_SLASH_START = "pager/start";
    private static final String NAVIGATOR_TYPE_PARAMETER = "navType";
    private static final String NAVIGATOR_TOGGLE_AUTOCOMPLETE = "autocomplete";

    public IssueNavigatorActionParams() {
    }

    public IssueNavigatorActionParams(Map params) {
        super(params);
    }

    public boolean isUserCreated() {
        return "true".equals(this.getFirstValueForKey("usercreated"));
    }

    public boolean isUpdateParamsRequired() {
        return this.containsKey("reset");
    }

    public boolean isClearOldFilter() {
        return this.containsKey("clear");
    }

    public boolean isUpdateExistingFilter() {
        return "update".equals(this.getFirstValueForKey("reset"));
    }

    public boolean isRefreshOnly() {
        return "true".equals(this.getFirstValueForKey("refreshFilter"));
    }

    public boolean isCreateNewFilter() {
        return this.containsKey("createNew");
    }

    public boolean isLoadSavedFilter() {
        return this.containsKey("requestId");
    }

    public SearchContext getSearchContext() {
        List<Long> projectIds;
        String[] projectIdsArray = this.getValuesForKey("pid");
        if (projectIdsArray != null) {
            projectIds = ParameterUtils.getLongListFromStringArray(projectIdsArray);
            projectIds.remove(-1L);
        } else {
            projectIds = null;
        }
        Object[] issueTypeIdsArray = this.getValuesForKey("type");
        List issueTypeIds = issueTypeIdsArray != null ? EasyList.buildNonNull((Object[])issueTypeIdsArray) : null;
        return new SearchContextImpl(null, projectIds, issueTypeIds);
    }

    public boolean isAddParamsRequired() {
        return this.containsKey("addParams");
    }

    public boolean isTooComplex() {
        return this.containsKey("tooComplex");
    }

    public final boolean isNavigatorTypeSpecified() {
        return this.containsKey(NAVIGATOR_TYPE_PARAMETER);
    }

    public final IssueNavigatorType getNavigatorType() {
        String str = this.getFirstValueForKey(NAVIGATOR_TYPE_PARAMETER);
        if (StringUtils.isNotBlank((String)str)) {
            return IssueNavigatorType.getTypeFromString(str);
        }
        return null;
    }

    public final boolean isAutocompletePreferenceSpecified() {
        return this.containsKey(NAVIGATOR_TOGGLE_AUTOCOMPLETE);
    }

    public final Boolean getNewAutocompletePreference() {
        String str = this.getFirstValueForKey(NAVIGATOR_TOGGLE_AUTOCOMPLETE);
        if (StringUtils.isNotBlank((String)str)) {
            return Boolean.valueOf(str);
        }
        return null;
    }

    public boolean isPagerStartSpecified() {
        return this.containsKey(PAGER_SLASH_START);
    }

    public int getPagerStart() {
        try {
            String pageStart = this.getFirstValueForKey(PAGER_SLASH_START);
            return Integer.valueOf(pageStart);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

