/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.tabpanels.CommentAction;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommentTabPanel
extends AbstractIssueTabPanel {
    private final CommentManager commentManager;
    private final CommentPermissionManager commentPermissionManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final IssueManager issueManager;
    private final DateTimeFormatter dateTimeFormatter;

    public CommentTabPanel(CommentManager commentManager, CommentPermissionManager commentPermissionManager, IssueManager issueManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, DateTimeFormatter dateTimeFormatter) {
        this.commentManager = commentManager;
        this.commentPermissionManager = commentPermissionManager;
        this.issueManager = issueManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public List<IssueAction> getActions(Issue issue, User user) {
        List<Comment> userComments = this.commentManager.getCommentsForUser(issue, user);
        ArrayList<IssueAction> commentActions = new ArrayList<IssueAction>();
        boolean issueIsInEditableWorkflow = this.issueManager.isEditable(issue);
        boolean canDeleteAllComments = issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteAllPermission(user, issue);
        boolean canDeleteOwnComments = canDeleteAllComments || issueIsInEditableWorkflow && this.commentPermissionManager.hasDeleteOwnPermission(user, issue);
        boolean canEditAllComments = issueIsInEditableWorkflow && this.commentPermissionManager.hasEditAllPermission(user, issue);
        boolean canEditOwnComments = canEditAllComments || issueIsInEditableWorkflow && this.commentPermissionManager.hasEditOwnPermission(user, issue);
        for (Comment comment : userComments) {
            boolean canDelete = canDeleteAllComments || canDeleteOwnComments && this.commentManager.isUserCommentAuthor(user, comment);
            boolean canEdit = canEditAllComments || canEditOwnComments && this.commentManager.isUserCommentAuthor(user, comment);
            commentActions.add(new CommentAction(this.descriptor, comment, canEdit, canDelete, this.rendererManager, this.fieldLayoutManager, this.dateTimeFormatter));
        }
        if (commentActions.isEmpty()) {
            GenericMessageAction action = new GenericMessageAction(this.descriptor.getI18nBean().getText("viewissue.nocomments"));
            return Lists.newArrayList((Object[])new IssueAction[]{action});
        }
        Collections.sort(commentActions, IssueActionComparator.COMPARATOR);
        return commentActions;
    }

    @Override
    public boolean showPanel(Issue issue, User remoteUser) {
        return true;
    }
}

