/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.subscription;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.subscription.SendFilterJob;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueItem;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.opensymphony.util.TextUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class DefaultSubscriptionManager
extends MailingListCompiler
implements SubscriptionManager {
    private static final Logger log = Logger.getLogger(DefaultSubscriptionManager.class);
    public static final String SUBSCRIPTION_PREFIX = "SUBSCRIPTION_";
    public static final String SUBSCRIPTION_IDENTIFIER = "SEND_SUBSCRIPTION";
    private final OfBizDelegator delegator;
    private final MailQueue mailQueue;
    private final SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory;
    private final GroupManager groupManager;

    public DefaultSubscriptionManager(OfBizDelegator delegator, MailQueue mailQueue, TemplateManager templateManager, SubscriptionMailQueueItemFactory subscriptionMailQueueItemFactory, ProjectRoleManager projectRoleManager, GroupManager groupManager) {
        super(templateManager, projectRoleManager);
        this.delegator = delegator;
        this.mailQueue = mailQueue;
        this.subscriptionMailQueueItemFactory = subscriptionMailQueueItemFactory;
        this.groupManager = groupManager;
    }

    @Override
    public boolean hasSubscription(User user, Long filterId) throws GenericEntityException {
        return !this.getSubscriptions(user, filterId).isEmpty();
    }

    private GenericValue getSubscription(Long subId) throws GenericEntityException {
        return this.delegator.findByPrimaryKey("FilterSubscription", EasyMap.build((Object)"id", (Object)subId));
    }

    @Override
    public GenericValue getSubscription(User user, Long subId) throws GenericEntityException {
        return EntityUtil.getOnly(this.delegator.findByAnd("FilterSubscription", EasyMap.build((Object)"username", (Object)user.getName(), (Object)"id", (Object)subId)));
    }

    @Override
    public GenericValue getSubscriptionFromTriggerName(String triggerName) throws GenericEntityException {
        return this.getSubscription(new Long(triggerName.substring(SUBSCRIPTION_PREFIX.length(), triggerName.length())));
    }

    @Override
    public List<GenericValue> getSubscriptions(User user, Long filterId) throws GenericEntityException {
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        entityExpressions.add(new EntityExpr("username", EntityOperator.EQUALS, (Object)user.getName()));
        Collection<String> groups = this.groupManager.getGroupNamesForUser(user.getName());
        for (String group : groups) {
            entityExpressions.add(new EntityExpr("group", EntityOperator.EQUALS, (Object)group));
        }
        EntityConditionList ownershipCondition = new EntityConditionList(entityExpressions, EntityOperator.OR);
        EntityExpr filterCondition = new EntityExpr("filterID", EntityOperator.EQUALS, (Object)filterId);
        return this.delegator.findByAnd("FilterSubscription", EasyList.build((Object)filterCondition, (Object)ownershipCondition));
    }

    @Override
    public Trigger getTriggerFromSubscription(GenericValue subscription) throws SchedulerException {
        return this.getScheduler().getTrigger(SUBSCRIPTION_PREFIX + subscription.getLong("id"), SUBSCRIPTION_IDENTIFIER);
    }

    @Override
    public void updateSubscription(User user, Long subId, String groupName, Trigger trigger, Boolean emailOnEmpty) throws DataAccessException {
        try {
            this.getScheduler().unscheduleJob(SUBSCRIPTION_PREFIX + subId, SUBSCRIPTION_IDENTIFIER);
            GenericValue subscriptionGV = this.getSubscription(user, subId);
            Map<String, String> fields = MapBuilder.build("username", user.getName(), "group", groupName, "emailOnEmpty", emailOnEmpty.toString());
            subscriptionGV.setFields(fields);
            subscriptionGV.store();
            if (this.getScheduler().isPaused() || this.getScheduler().isShutdown()) {
                throw new IllegalStateException("The scheduler is paused or shutdown so the subscription was not created.");
            }
            this.populateTriggerFields(trigger, subscriptionGV.getLong("id"));
            this.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new DataAccessException(e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
    }

    private void populateTriggerFields(Trigger trigger, Long subscriptionId) throws SchedulerException {
        JobDetail jd = new JobDetail(SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, SendFilterJob.class, false, true, false);
        trigger.setName(SUBSCRIPTION_PREFIX + subscriptionId);
        trigger.setGroup(SUBSCRIPTION_IDENTIFIER);
        trigger.setJobName(SUBSCRIPTION_IDENTIFIER);
        trigger.setJobGroup(SUBSCRIPTION_IDENTIFIER);
        this.getScheduler().addJob(jd, true);
    }

    @Override
    public List<GenericValue> getAllSubscriptions(Long filterId) {
        return this.delegator.findByAnd("FilterSubscription", EasyMap.build((Object)"filterID", (Object)filterId));
    }

    @Override
    public List<GenericValue> getAllSubscriptions() {
        return this.delegator.findAll("FilterSubscription");
    }

    @Override
    public GenericValue createSubscription(User user, Long filterId, String groupName, Long period, Boolean emailOnEmpty) {
        SimpleTrigger trigger = new SimpleTrigger(SUBSCRIPTION_PREFIX, SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, SUBSCRIPTION_IDENTIFIER, new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, period * DateUtils.SECOND_MILLIS);
        return this.createSubscription(user, filterId, groupName, (Trigger)trigger, emailOnEmpty);
    }

    @Override
    public GenericValue createSubscription(User user, Long filterId, String groupName, Trigger trigger, Boolean emailOnEmpty) {
        if (!TextUtils.stringSet((String)groupName)) {
            groupName = null;
        }
        Map columns = EasyMap.build((Object)"filterID", (Object)filterId, (Object)"username", (Object)user.getName(), (Object)"group", (Object)groupName, (Object)"lastRun", null);
        columns.put("emailOnEmpty", emailOnEmpty.toString());
        GenericValue subscriptionGV = null;
        try {
            if (this.getScheduler().isPaused() || this.getScheduler().isShutdown()) {
                throw new IllegalStateException("The scheduler is paused or shutdown so the subscription was not created.");
            }
            subscriptionGV = EntityUtils.createValue("FilterSubscription", columns);
            this.populateTriggerFields(trigger, subscriptionGV.getLong("id"));
            this.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            throw new DataAccessException(e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException(e);
        }
        return subscriptionGV;
    }

    @Override
    public void deleteSubscription(Long subId) throws Exception {
        GenericValue subscriptionGV = this.getSubscription(subId);
        if (this.getScheduler().getTrigger(SUBSCRIPTION_PREFIX + subscriptionGV.getLong("id"), SUBSCRIPTION_IDENTIFIER) != null) {
            this.getScheduler().unscheduleJob(SUBSCRIPTION_PREFIX + subscriptionGV.getLong("id"), SUBSCRIPTION_IDENTIFIER);
        } else {
            log.warn((Object)("Unable to find a quartz trigger for the subscription: " + subscriptionGV.getLong("id") + " removing the subscription anyway."));
        }
        subscriptionGV.remove();
    }

    @Override
    public void deleteSubscriptionsForUser(User user) throws Exception {
        List<GenericValue> subscriptionGvs = this.delegator.findByAnd("FilterSubscription", EasyMap.build((Object)"username", (Object)user.getName()));
        for (GenericValue subscription : subscriptionGvs) {
            this.deleteSubscription(subscription.getLong("id"));
        }
    }

    @Override
    public void runSubscription(GenericValue sub) throws Exception {
        Timestamp ts = new Timestamp(new Date().getTime());
        sub.set("lastRun", (Object)ts);
        sub.store();
        SubscriptionMailQueueItem item = this.subscriptionMailQueueItemFactory.getSubscriptionMailQueueItem(sub);
        this.mailQueue.addItem((MailQueueItem)item);
    }

    @Override
    public void runSubscription(User u, Long subId) throws Exception {
        this.runSubscription(this.getSubscription(u, subId));
    }

    @Override
    public void deleteSubscriptionsForGroup(Group group) throws Exception {
        List<GenericValue> subscriptionGvs = this.delegator.findByAnd("FilterSubscription", EasyMap.build((Object)"group", (Object)group.getName()));
        for (GenericValue subscription : subscriptionGvs) {
            this.deleteSubscription(subscription.getLong("id"));
        }
    }

    Scheduler getScheduler() {
        return ComponentManager.getComponentInstanceOfType(Scheduler.class);
    }
}

